//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * C
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Intersection/LineIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// _
//------------------------------------------------------------------------------
// _
bool LineIntersection::intersect(
	const Line& line, const Vector3& point, float range){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// C
//------------------------------------------------------------------------------
// C
bool LineIntersection::intersect(
	const Line& line0, const Line& line1, float range){
	return (line0.getSquaredDistance(line1) <= (range * range));
}
//------------------------------------------------------------------------------
// w{bNX
//------------------------------------------------------------------------------
// w{bNX
bool LineIntersection::intersect(const Line& line, const OrientedBox& ob){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// ʌ
bool LineIntersection::intersect(const Line& line, const Plane& plane){
	float denominator = line.getDirection().dotProduct(plane.getNormal());
	if(Math::abs(denominator) <= Math::epsilon){
		// ʂɕsȃC͌_ʂɐڂĂΌ
		float distance = plane.getDistance(line.getOrigin());
		return (Math::abs(distance) <= Math::epsilon);
	}
	// słȂΌ
	return true;
}
//------------------------------------------------------------------------------
// C
//------------------------------------------------------------------------------
// C
bool LineIntersection::intersect(
	const Line& line, const Ray& ray, float range){
	return (line.getSquaredDistance(ray) <= (range * range));
}
//------------------------------------------------------------------------------
// ZOg
//------------------------------------------------------------------------------
// ZOg
bool LineIntersection::intersect(
	const Line& line, const Segment& segment, float range){
	return (line.getSquaredDistance(segment) <= (range * range));
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
bool LineIntersection::intersect(const Line& line, const Sphere& sphere){
	// SƂ̋aȓȂ
	float squaredDistance = line.getSquaredDistance(sphere.getCenter());
	float radius = sphere.getRadius();
	return (squaredDistance <= (radius * radius));
}
//------------------------------------------------------------------------------
// Op
//------------------------------------------------------------------------------
// Op
bool LineIntersection::intersect(const Line& line, const Triangle& triangle){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
