//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * JvZ
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Intersection/CapsuleIntersection.h"

#include "Geometry/Primitive/Capsule.h"

namespace Lamp{

//------------------------------------------------------------------------------
// _
//------------------------------------------------------------------------------
// _
bool CapsuleIntersection::intersect(
	const Capsule& capsule, const Vector3& point){
	// ZOgƓ_Ƃ̋狁߂
	const Vector3& direction = capsule.getDirection();
	float radius = capsule.getRadius();
	Vector3 distance = point - capsule.getOrigin();
	float t = distance.dotProduct(direction);
	// t-瓊eȂ
	if(t > 0.f){
		float squaredLength = direction.getSquaredLength();
		if(t >= squaredLength){
			// t𒴂Ăꍇ̓^[Qbgʒű
			// t = 1.f;
			distance -= direction;
		}else{
			t /= squaredLength;
			distance -= t * direction;
		}
	}
	// ڐG_origin + direction * t + distance
	// rŐڐG_߂ĂقBdistanceg܂킵Ă
	return distance.getSquaredLength() <= (radius * radius);
}
//------------------------------------------------------------------------------
// JvZ
//------------------------------------------------------------------------------
// JvZ
bool CapsuleIntersection::intersect(
	const Capsule& capsule0, const Capsule& capsule1){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// R[
//------------------------------------------------------------------------------
// R[
bool CapsuleIntersection::intersect(const Capsule& capsule, const Cone& cone){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// C
//------------------------------------------------------------------------------
// C
bool CapsuleIntersection::intersect(const Capsule& capsule, const Line& line){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// w{bNX
//------------------------------------------------------------------------------
// w{bNX
bool CapsuleIntersection::intersect(
	const Capsule& capsule, const OrientedBox& ob){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// ʌ
bool CapsuleIntersection::intersect(const Capsule& capsule, const Plane& plane){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// C
//------------------------------------------------------------------------------
// C
bool CapsuleIntersection::intersect(const Capsule& capsule, const Ray& ray){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// ZOg
//------------------------------------------------------------------------------
// ZOg
bool CapsuleIntersection::intersect(
	const Capsule& capsule, const Segment& segment){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
bool CapsuleIntersection::intersect(
	const Capsule& capsule, const Sphere& sphere){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// Op
//------------------------------------------------------------------------------
// Op
bool CapsuleIntersection::intersect(
	const Capsule& capsule, const Triangle& triangle){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
