//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {bNX
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Intersection/AxisAlignedBoxIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// _
//------------------------------------------------------------------------------
// _
bool AxisAlignedBoxIntersection::intersect(
	const AxisAlignedBox& aab, const Vector3& point){
	const Vector3& max = aab.getMaximum();
	const Vector3& min = aab.getMinimum();
	if(point.x < min.x){ return false; }
	if(point.y < min.y){ return false; }
	if(point.z < min.z){ return false; }
	if(point.x > max.x){ return false; }
	if(point.y > max.y){ return false; }
	if(point.z > max.z){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// {bNX
//------------------------------------------------------------------------------
// {bNX
bool AxisAlignedBoxIntersection::intersect(
	const AxisAlignedBox& aab0, const AxisAlignedBox& aab1){
	const Vector3& max0 = aab0.getMaximum();
	const Vector3& min0 = aab0.getMinimum();
	const Vector3& max1 = aab1.getMaximum();
	const Vector3& min1 = aab1.getMinimum();
	// ̍őAŏŔrĔ͈͂ĂȂΌȂ
	if(max0.x < min1.x){ return false; }
	if(max0.y < min1.y){ return false; }
	if(max0.z < min1.z){ return false; }
	if(min0.x > max1.x){ return false; }
	if(min0.y > max1.y){ return false; }
	if(min0.z > max1.z){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// JvZ
//------------------------------------------------------------------------------
// JvZ
bool AxisAlignedBoxIntersection::intersect(
	const AxisAlignedBox& aab, const Capsule& capsule){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// R[
//------------------------------------------------------------------------------
// R[
bool AxisAlignedBoxIntersection::intersect(
	const AxisAlignedBox& aab, const Cone& cone){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// C
//------------------------------------------------------------------------------
// C
bool AxisAlignedBoxIntersection::intersect(
	const AxisAlignedBox& aab, const Line& line){
	const Vector3& max = aab.getMaximum();
	const Vector3& min = aab.getMinimum();
	const Vector3& direction = line.getDirection();
	const Vector3& origin = line.getOrigin();
	float totalMinT = -Limit::floatMax;
	float totalMaxT = Limit::floatMax;
	// eɊւĒׂ
	for(int i = 0; i < 3; i++){
		// C̕ɐׂ
		float axisDirection = direction.array[i];
		if(Math::abs(axisDirection) <= Math::epsilon){
			// ̒lωȂ̂ŃČ_͈͓̎̔ɖƌȂ
			if((origin.array[i] < min.array[i]) ||
				(origin.array[i] > max.array[i])){ return false; }
			continue;
		}
		// ŏlƍől𓊉e
		float minT = (min.array[i] - origin.array[i]) / axisDirection;
		float maxT = (max.array[i] - origin.array[i]) / axisDirection;
		if(minT > maxT){ Math::swap(minT, maxT); }
		// g[^̍ŏlAől̍XV
		if(minT > totalMinT){ totalMinT = minT; }
		if(maxT < totalMaxT){ totalMaxT = maxT; }
		// T͈̔͂`FbN
		if(totalMinT > totalMaxT){
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// w{bNX
//------------------------------------------------------------------------------
// w{bNX
bool AxisAlignedBoxIntersection::intersect(
	const AxisAlignedBox& aab, const OrientedBox& ob){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// ʌ
bool AxisAlignedBoxIntersection::intersect(
	const AxisAlignedBox& aab, const Plane& plane){
	// ŏ̃R[i[ʂ̂ǂ瑤ɂׂ̂
	float distance = plane.dotProduct(aab.getCorner(0));
	if(distance > 0.f){
		// ʂ̕ɒ_ΌĂ
		for(int i = 1; i < 8; i++){
			distance = plane.dotProduct(aab.getCorner(i));
			if(distance <= 0.f){ return true; }
		}
	}else if(distance < 0.f){
		// ʂ̐ɒ_ΌĂ
		for(int i = 1; i < 8; i++){
			distance = plane.dotProduct(aab.getCorner(i));
			if(distance >= 0.f){ return true; }
		}
	}else{
		// TCY0łȂΌĂ
		return (aab.getSize() != Vector3::zero);
	}
	return false;
}
//------------------------------------------------------------------------------
// C
//------------------------------------------------------------------------------
// C
bool AxisAlignedBoxIntersection::intersect(
	const AxisAlignedBox& aab, const Ray& ray){
	const Vector3& max = aab.getMaximum();
	const Vector3& min = aab.getMinimum();
	const Vector3& direction = ray.getDirection();
	const Vector3& origin = ray.getOrigin();
	float totalMinT = -Limit::floatMax;
	float totalMaxT = Limit::floatMax;
	// eɊւĒׂ
	for(int i = 0; i < 3; i++){
		// C̕ɐׂ
		float axisDirection = direction.array[i];
		if(Math::abs(axisDirection) <= Math::epsilon){
			// ̒lωȂ̂ŃČ_͈͓̎̔ɖƌȂ
			if((origin.array[i] < min.array[i]) ||
				(origin.array[i] > max.array[i])){ return false; }
			continue;
		}
		// ŏlƍől𓊉e
		float minT = (min.array[i] - origin.array[i]) / axisDirection;
		float maxT = (max.array[i] - origin.array[i]) / axisDirection;
		if(minT > maxT){ Math::swap(minT, maxT); }
		// g[^̍ŏlAől̍XV
		if(minT > totalMinT){ totalMinT = minT; }
		if(maxT < totalMaxT){ totalMaxT = maxT; }
		// T͈̔͂`FbN
		if(totalMinT > totalMaxT){ return false; }
		if(totalMaxT < 0.f){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// ZOg
//------------------------------------------------------------------------------
// ZOg
bool AxisAlignedBoxIntersection::intersect(
	const AxisAlignedBox& aab, const Segment& segment){
	const Vector3& max = aab.getMaximum();
	const Vector3& min = aab.getMinimum();
	const Vector3& direction = segment.getDirection();
	const Vector3& origin = segment.getOrigin();
	float totalMinT = -Limit::floatMax;
	float totalMaxT = Limit::floatMax;
	// eɊւĒׂ
	for(int i = 0; i < 3; i++){
		// ZOg̕ɐׂ
		float axisDirection = direction.array[i];
		if(Math::abs(axisDirection) <= Math::epsilon){
			// ̒lωȂ̂ŃZOǧ_͈͓̎̔ɖƌȂ
			if((origin.array[i] < min.array[i]) ||
				(origin.array[i] > max.array[i])){ return false; }
			continue;
		}
		// ŏlƍől𓊉e
		float minT = (min.array[i] - origin.array[i]) / axisDirection;
		float maxT = (max.array[i] - origin.array[i]) / axisDirection;
		if(minT > maxT){ Math::swap(minT, maxT); }
		// g[^̍ŏlAől̍XV
		if(minT > totalMinT){ totalMinT = minT; }
		if(maxT < totalMaxT){ totalMaxT = maxT; }
		// T͈̔͂`FbN
		if(totalMinT > totalMaxT){ return false; }
		if(totalMaxT < 0.f){ return false; }
		if(totalMinT > 1.f){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
bool AxisAlignedBoxIntersection::intersect(
	const AxisAlignedBox& aab, const Sphere& sphere){
	const Vector3& max = aab.getMaximum();
	const Vector3& min = aab.getMinimum();
	const Vector3& center = sphere.getCenter();
	float radius = sphere.getRadius();

	// ê͂ݏȏaaȏȂĂȂ
	float totalDitance = 0.f;
	float distance;

	distance = min.x - center.x;
	if(distance > 0.f){ totalDitance += distance * distance; }
	distance = center.x - max.x;
	if(distance > 0.f){ totalDitance += distance * distance; }

	distance = min.y - center.y;
	if(distance > 0.f){ totalDitance += distance * distance; }
	distance = center.y - max.y;
	if(distance > 0.f){ totalDitance += distance * distance; }

	distance = min.z - center.z;
	if(distance > 0.f){ totalDitance += distance * distance; }
	distance = center.z - max.z;
	if(distance > 0.f){ totalDitance += distance * distance; }

	return (totalDitance <= (radius * radius));
}
//------------------------------------------------------------------------------
// Op
//------------------------------------------------------------------------------
// Op
bool AxisAlignedBoxIntersection::intersect(
	const AxisAlignedBox& aab, const Triangle& triangle){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
