//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * EBhENG[^
 * @author Junpee
 */

#include "LampBasic.h"
#include "Framework/Utility/WindowCreator.h"

namespace Lamp{

//------------------------------------------------------------------------------
// EBhE쐬p[^RXgN^
WindowCreator::CreateParameter::CreateParameter(){
	windowName_ = "windowName";
	instanceHandle_ = NULL;
	windowProcedure_ = NULL;
	windowStyle_ =
		WS_OVERLAPPED |
		WS_CAPTION |
		WS_SYSMENU |
		WS_THICKFRAME |
		WS_MINIMIZEBOX |
		WS_MAXIMIZEBOX |
		WS_VISIBLE;
	createWidth_ = 640;
	createHeight_ = 480;
	iconHandle_ = ::LoadIcon(NULL, IDI_WINLOGO);
	smallIconHandle_ = ::LoadIcon(NULL, IDI_WINLOGO);
	cursorHandle_ = ::LoadCursor(NULL, IDC_ARROW);
}
//------------------------------------------------------------------------------
// EBhE̍쐬
HWND WindowCreator::create(const CreateParameter& parameter){
	// EBhENX̓o^
	WNDCLASSEX windowClass;
	String windowClassName = parameter.windowName_ + "WindowClass";
	windowClass.cbSize = sizeof(WNDCLASSEX);	// WindowClass̃TCY
	windowClass.style = 0;						// EBhEX^C
	windowClass.lpfnWndProc =					// EBhEvV[W
		parameter.windowProcedure_;
	windowClass.cbClsExtra = 0;					// gTCY
	windowClass.cbWndExtra = 0;					// gTCY
	windowClass.hInstance =						// CX^Xnh
		parameter.instanceHandle_;
	windowClass.hIcon =							// ACRnh
		parameter.iconHandle_;
	windowClass.hIconSm =						// X[ACRnh
		parameter.smallIconHandle_;
	windowClass.hCursor =						// J[\nh
		parameter.cursorHandle_;
	windowClass.hbrBackground =					// wiuV
		(HBRUSH)::GetStockObject(GRAY_BRUSH);
	windowClass.lpszMenuName = NULL;			// j[
	windowClass.lpszClassName =					// EBhENX
		windowClassName.getBytes();
	if(!::RegisterClassEx(&windowClass)){
		ErrorOut("SimpleFramework::createWindow() RegisterClassEx");
		return NULL;
	}
	// EBhETCY̎Zo
	RECT windowRect;
	::SetRect(&windowRect, 0, 0,
		parameter.createWidth_, parameter.createHeight_);
	// j[ɂ͑ΉȂ
	::AdjustWindowRect(&windowRect, parameter.windowStyle_, false);
	// EBhE̍쐬
	return ::CreateWindowEx(
		0,										// gEBhEX^C
		windowClassName.getBytes(),				// EBhENX
		parameter.windowName_.getBytes(),		// EBhE
		parameter.windowStyle_,					// EBhEX^C
		CW_USEDEFAULT,							// EBhEXʒu
		CW_USEDEFAULT,							// EBhEYʒu
		(windowRect.right - windowRect.left),	// EBhE
		(windowRect.bottom - windowRect.top),	// EBhE
		NULL,									// eEBhE
		NULL,									// j[nh
		parameter.instanceHandle_,				// CX^Xnh
		NULL);									// EBhE쐬f[^
}
//------------------------------------------------------------------------------
// EBhE̔j
void WindowCreator::destroy(HWND windowHandle){
	// j[̔j
	HMENU menuHandle = GetMenu(windowHandle);
	if(menuHandle != NULL){ DestroyMenu(menuHandle); }
	// EBhE̔j
	DestroyWindow(windowHandle);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
