//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Vvt[[N
 * @author Junpee
 */

#include "LampBasic.h"
#include "Framework/System/SimpleFramework.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/System/GraphicsDevice.h"
#include "Input/System/LampInput.h"
#include "Sound/System/LampSound.h"
#include "Core/Utility/FPSController.h"

namespace Lamp{

// CX^X
SimpleFramework* SimpleFramework::instance_ = NULL;

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
SimpleFramework::SimpleFramework(const String& name) : name_(name){
	// oNA
	windowHandle_ = NULL;
	minimumWindowSize_.set(320, 240);
	backGroundColor_.set(0x80, 0x80, 0x80, 0);
	fpsController_ = new FPSController();
	keyboard_ = NULL;
	mouse_ = NULL;
	// ftHgł̓EBhE[hŋN
	startFullscreen_ = false;
	// LampGraphics
	LampGraphics::initialize();
}
//------------------------------------------------------------------------------
// fXgN^
SimpleFramework::~SimpleFramework(){
	SafeDelete(fpsController_);
}
//------------------------------------------------------------------------------
// s
int SimpleFramework::execute(HINSTANCE instance){
	int result = 1;
	// t[[N
	if(frameworkInitialize(instance)){
		// [UĂяo
		if(initialize()){
			// t[[Ns
			result = frameworkExecute();
		}
		// [UnĂяo
		finalize();
	}
	// t[[Nn
	frameworkFinalize();
	return result;
}
//------------------------------------------------------------------------------
// t[[N\bh
//------------------------------------------------------------------------------
// t[[N̏
bool SimpleFramework::frameworkInitialize(HINSTANCE instanceHandle){
	// EBhEnhw肳ĂȂ΃EBhE쐬
	if(windowHandle_ == NULL){
		createWindowParameter_.windowName_ = name_;
		createWindowParameter_.instanceHandle_ = instanceHandle;
		// t[[ÑvV[W̓p[^NULLꍇ̂ݎgp
		if(createWindowParameter_.windowProcedure_ == NULL){
			createWindowParameter_.windowProcedure_ =
				registrationWindowProcedure;
		}
		windowHandle_ = WindowCreator::create(createWindowParameter_);
	}
	// EBhE쐬łȂΏs
	if(windowHandle_ == NULL){ return false; }

	// GraphicsfoCX
	if(!LampGraphics::initializeDevice(windowHandle_, startFullscreen_)){
		return false;
	}
	// wiNA
	GraphicsDevice::getInstance()->clear(backGroundColor_);

	// LampInput
	if(!LampInput::initialize(
		instanceHandle, windowHandle_, LampInput::modeBuffering)){
		return false;
	}
	keyboard_ = LampInput::getKeyboard();
	mouse_ = LampInput::getMouse();

	// LampSound
	if(!LampSound::initialize(windowHandle_)){ return false; }

	// CX^X|C^ݒ
	Assert(instance_ == NULL);
	instance_ = this;
	return true;
}
//------------------------------------------------------------------------------
// t[[Ňn
void SimpleFramework::frameworkFinalize(){
	// CX^X|C^NA
	instance_ = NULL;
	// LampSounďn
	LampSound::finalize();
	// LampInpuťn
	LampInput::finalize();
	// LampOtBNX̌n
	LampGraphics::finalize();
	// EBhE̔j
	WindowCreator::destroy(windowHandle_);
	// LampRǍn
	LampCore::finalize();
}
//------------------------------------------------------------------------------
// t[[N̎s
int SimpleFramework::frameworkExecute(){
	// AvP[VANeBułȂ삳
	// ANeBułȂɓ삳Ȃ悤ɂɂGetMessage()gp
	MSG message;
	bool gotMessage;
	message.message = WM_NULL;
	::PeekMessage(&message, NULL, 0, 0, PM_NOREMOVE);
	// ̓obt@UNA
	if(LampInput::getInputMode() == LampInput::modeBuffering){
		LampInput::bufferClear();
	}
	// bZ[W[v
	while(message.message != WM_QUIT){
		// bZ[W
		gotMessage = (PeekMessage(&message, NULL, 0, 0, PM_REMOVE) != 0);
		if(gotMessage){
			TranslateMessage(&message);
			DispatchMessage(&message);
		}else{
			// bZ[W΃C[vs
			mainLoop();
		}
	}
	return 0;
}
//------------------------------------------------------------------------------
// [v̏
//------------------------------------------------------------------------------
// C[v
void SimpleFramework::mainLoop(){
	// 1/60bƂɒǉ̓obt@̐s
	// ɂ`t[[gɍEȂQ[xł
	// Q[x1FPSȉɂȂ悤łΉiv[vhߓ͂؂̂Ă
	int inputCount = 0;
	LampInput::waitForInput();
	while(LampInput::hasMoreInput()){
		LampInput::nextInput();
		frameworkRun();
		inputCount++;
		if(inputCount == 60){
			LampInput::bufferClear();
			break;
		}
	}
	// `揀
	frameworkRenderSetup();
	// v[e[Vs
	frameworkPresentation();
	// `
	frameworkRender();
}
//------------------------------------------------------------------------------
// t[[Ns
void SimpleFramework::frameworkRun(){
	run();
	// EscL[ŏI
	if(keyboard_->down(Keyboard::keyEscape)){ PostQuitMessage(0); }
}
//------------------------------------------------------------------------------
// t[[N_O
void SimpleFramework::frameworkRenderSetup(){
	renderSetup();
}
//------------------------------------------------------------------------------
// t[[Nv[e[V
bool SimpleFramework::frameworkPresentation(){
	// TEh̃v[e[V
	LampSound::presentation();

	// FPS̒Aɂ60FPSȏɂȂȂ
	fpsController_->sleep();

	// OtBbNX̃v[e[V
	return GraphicsDevice::getInstance()->presentation();
}
//------------------------------------------------------------------------------
// t[[N_O
void SimpleFramework::frameworkRender(){
	// wiNA
	GraphicsDevice::getInstance()->clear(backGroundColor_);
	render();
}
//------------------------------------------------------------------------------
// EBhEvV[W֘A
//------------------------------------------------------------------------------
// o^pEBhEvV[W
LRESULT CALLBACK SimpleFramework::registrationWindowProcedure(
	HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam){
	// OȂftHgvV[Ŵ݂Ă
	if(instance_ == NULL){
		return DefWindowProc(windowHandle, message, wParam, lParam);
	}

	// [UvV[WĂяo
	LRESULT result;
	result = instance_->windowProcedure(windowHandle, message, wParam, lParam);
	if(result != 0){ return result; }

	// LampvV[WĂяo
	result = LampCore::windowProcedure(windowHandle, message, wParam, lParam);
	if(result != 0){ return result; }

	// t[[NvV[WĂяo
	return instance_->frameworkWindowProcedure(
		windowHandle, message, wParam, lParam);
}
//------------------------------------------------------------------------------
// t[[NEBhEvV[W
LRESULT SimpleFramework::frameworkWindowProcedure(
	HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam){
	switch(message){
	// ŏTCY̐ݒ
	case WM_GETMINMAXINFO:
		((MINMAXINFO*)lParam)->ptMinTrackSize.x = minimumWindowSize_.width;
		((MINMAXINFO*)lParam)->ptMinTrackSize.y = minimumWindowSize_.height;
		break;
	}
	// ŌɃftHgEBhEvV[WĂ
	return DefWindowProc(windowHandle, message, wParam, lParam);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
