//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {t[[N
 * @author Junpee
 */

#include "LampBasic.h"
#include "Framework/System/BasicFramework.h"
#include "Core/Utility/FPSMeasurement.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Enumeration/GraphicsDeviceEnumeration.h"
#include "Graphics/System/GraphicsDevice.h"
#include "Graphics/Renderer/RenderingDevice.h"
#include "Input/System/LampInput.h"

#include "Core/System/StringMethod.h" // StdStrcpy

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^AfXgN^
//------------------------------------------------------------------------------
// RXgN^
BasicFramework::BasicFramework(const String& name) : SimpleFramework(name){
	// tHgLq
	font_ = NULL;
	::memset(&fontDescription_, 0, sizeof(D3DXFONT_DESC));
	fontDescription_.Height = 14;
	fontDescription_.Weight = FW_NORMAL; 
	fontDescription_.Weight = FW_BOLD; 
	fontDescription_.CharSet = SHIFTJIS_CHARSET;
	StdStrcpy(fontDescription_.FaceName, "lr SVbN");
	// FPSv
	drawFPSMeasurement_ = new FPSMeasurement();
	gameFPSMeasurement_ = new FPSMeasurement();
	drawFPS_ = gameFPS_ = 0.f;
	// OtBbNXfoCXmF邽߂̐ݒ
	GraphicsDeviceEnumeration::getInstance()->setConfirmGraphicsDevice(this);
	// foCXIuWFNgz_o^
	LampGraphics::addDeviceObjectHolder(this);
}
//------------------------------------------------------------------------------
// fXgN^
BasicFramework::~BasicFramework(){
	// foCXIuWFNgz_o^
	LampGraphics::removeDeviceObjectHolder(this);
	// FPSvn
	delete gameFPSMeasurement_;
	delete drawFPSMeasurement_;
}
//------------------------------------------------------------------------------
// t[[N\bh
//------------------------------------------------------------------------------
// C[v
void BasicFramework::mainLoop(){
	// 1/60bƂɒǉ̓obt@̐s
	// ɂ`t[[gɍEȂQ[xł
	// Q[x1FPSȉɂȂ悤łΉiv[vhߓ͂؂̂Ă
	int inputCount = 0;
	LampInput::waitForInput();
	while(LampInput::hasMoreInput()){
		LampInput::nextInput();
		frameworkRun();
		// Q[FPSv
		gameFPS_ = gameFPSMeasurement_->measurement();
		inputCount++;
		if(inputCount == 60){
			LampInput::bufferClear();
			break;
		}
	}
	// `揀
	frameworkRenderSetup();
	// v[e[Vs
	frameworkPresentation();
	// `
	frameworkRender();
	frameworkDrawInformation();
	// `FPSv
	drawFPS_ = drawFPSMeasurement_->measurement();
}
//------------------------------------------------------------------------------
// t[[Ns
void BasicFramework::frameworkRun(){
	SimpleFramework::frameworkRun();
	// Alt+EnterL[ŃtXN[ؑ
	if(keyboard_->down(Keyboard::keyEnter) &&
		(keyboard_->pressed(Keyboard::keyLeftAlt) ||
		keyboard_->pressed(Keyboard::keyRightAlt))){
		GraphicsDevice::getInstance()->toggleFullscreen();
	}
	// F9L[ŃfoCXč\z
	if(keyboard_->down(Keyboard::keyF9)){
		GraphicsDevice::getInstance()->rebuild();
	}
}
//------------------------------------------------------------------------------
// t[[N\
void BasicFramework::frameworkDrawInformation(){
	if(font_ == NULL){ return; }
	RenderingDevice* device = RenderingDevice::getInstance();
	if(!device->beginScene()){ return; }
	// ``Zo
	::GetClientRect(windowHandle_, &informationDrawRect_);
	int gap = 5;
	informationDrawRect_.top += gap;
	informationDrawRect_.bottom -= gap;
	informationDrawRect_.left += gap * 2;
	informationDrawRect_.right -= gap * 2;
	// `
	drawInformation();
	device->endScene();
}
//------------------------------------------------------------------------------
// `֘A
//------------------------------------------------------------------------------
// `
void BasicFramework::drawInformation(){
	drawInformationString(getFPSString(), Color4c::white, true, true);
}
//------------------------------------------------------------------------------
// 񕶎`
void BasicFramework::drawInformationString(
	const String& message, Color4c color, bool alignRight, bool alignBottom){
	if(font_ == NULL){ return; }
	// ACgtO쐬
	u_int alignFlag = 0;
	if(alignRight){
		alignFlag |= (DT_RIGHT | DT_SINGLELINE);
	}else{
		alignFlag |= DT_LEFT;
	}
	if(alignBottom){
		alignFlag |= (DT_BOTTOM | DT_SINGLELINE);
	}else{
		alignFlag |= DT_TOP;
	}
	// `
	font_->DrawText(NULL, message.getBytes(), -1, &informationDrawRect_,
		alignFlag, color.getARGB());
}
//------------------------------------------------------------------------------
// FPS̎擾
String BasicFramework::getFPSString() const{
	String fpsString;
	fpsString.format("Game %4.1f  Draw %4.1f", gameFPS_, drawFPS_);
	return fpsString;
}
//------------------------------------------------------------------------------
// foCXIuWFNg֘A
//------------------------------------------------------------------------------
// foCXIuWFNg̏
bool BasicFramework::initializeGraphicsDeviceObjects(){
	// tHg
	if(DirectXFailed(D3DXCreateFontIndirect(
		LampGraphics::getDirect3DDevice(), &fontDescription_, &font_))){
		ErrorOut("BasicFramework::initializeGraphicsDeviceObjects() "
			"tHg̍쐬Ɏs܂");
		SafeRelease(font_);
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̍폜
void BasicFramework::deleteGraphicsDeviceObjects(){
	// tHgn
	SafeRelease(font_);
}
//------------------------------------------------------------------------------
// foCXIuWFNg̃XgA
bool BasicFramework::restoreGraphicsDeviceObjects(){
	// tHg
	if(font_ != NULL){
		if(DirectXFailed(font_->OnResetDevice())){
			ErrorOut("BasicFramework::restoreGraphicsDeviceObjects() "
				"tHg̍쐬Ɏs܂");
			SafeRelease(font_);
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̖
void BasicFramework::invalidateGraphicsDeviceObjects(){
	// tHg
	if(font_ != NULL){ font_->OnLostDevice(); }
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
