//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ^C}
 * @author Junpee
 */

#include <windows.h>
#include "LampBasic.h"
#include "Core/Utility/Timer.h"
#include "Core/Debug/ErrorOutput.h"

namespace Lamp{

// 1ms̃NbN
float Timer::tickPerMillisecond_ = 0.f;

// ς݃tO
bool Timer::initialized_ = false;

//------------------------------------------------------------------------------
// 
void Timer::initialize(){
	if(initialized_){ return; }
	Tick frequencyValue;
	BOOL success = QueryPerformanceFrequency((LARGE_INTEGER*)&frequencyValue);
	if(success){
		tickPerMillisecond_ = (float)(frequencyValue.tick / 1000.f);
	}else{
		ErrorOut("x^C}̏Ɏs܂B");
		return;
	}
	initialized_ = true;
}
//------------------------------------------------------------------------------
// Ԃ̎擾
Timer::Tick Timer::getTick(){
	Tick tick;
	QueryPerformanceCounter((LARGE_INTEGER*)&tick);
	return tick;
}
//------------------------------------------------------------------------------
// ԊԊu̎擾
float Timer::getInterval(const Tick& previousTick){
	Tick nowTick = getTick();
	return (nowTick.tick - previousTick.tick) / tickPerMillisecond_;
}
//------------------------------------------------------------------------------
// ԊԊu̎擾
float Timer::getInterval(const Tick& previousTick, const Tick& afterTick){
	return (afterTick.tick - previousTick.tick) / tickPerMillisecond_;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
