//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XgOg[NiCU
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Utility/StringTokenizer.h"
#include "Core/System/StringMethod.h"

namespace Lamp{

// ftHgf~^
const String StringTokenizer::defaultDelimiter(" \t\n\r\f");

//------------------------------------------------------------------------------
// RXgN^
StringTokenizer::StringTokenizer() :
	base_(NULL), current_(NULL), tokenOffset_(0), delimiterOutput_(false){
}
//------------------------------------------------------------------------------
// 
void StringTokenizer::initialize(const char* target,
	 const String& delimiter, bool delimiterOutput){
	 base_ = current_ = target;
	 tokenOffset_ = 0;
	 delimiter_ = delimiter;
	 delimiterOutput_ = delimiterOutput;
	 nowToken_ = "";
	 previousToken_ = "";
}
//------------------------------------------------------------------------------
// 
void StringTokenizer::initialize(const String& target,
	const String& delimiter, bool delimiterOutput){
	targetString_ = target;
	initialize(target.getBytes(), delimiter, delimiterOutput);
}
//------------------------------------------------------------------------------
// fXgN^
StringTokenizer::~StringTokenizer(){
}
//------------------------------------------------------------------------------
// g[N܂邩ǂ
bool StringTokenizer::hasMoreTokens(){
	if(current_ == NULL){ return false; }
	if(delimiterOutput_){ return ((*current_) != '\0'); }
	while(true){
		if((*current_) == '\0'){ return false; }
		int index = (int)StdStrcspn(current_, delimiter_.getBytes());
		if(index != 0){ break; }
		current_ = StdStrinc(current_);
	}
	return true;
}
//------------------------------------------------------------------------------
// ̃g[N擾
String StringTokenizer::getNextToken(){
	Assert((*current_) != '\0');
	tokenOffset_ = (int)(current_ - base_);
	// f~^o
	int index = (int)StdStrcspn(current_, delimiter_.getBytes());
	if(delimiterOutput_ && (index == 0)){
		const char* prevCurrent = current_;
		current_ = StdStrinc(current_);
		int length = (int)(current_ - prevCurrent);
		char* newString = new char[length + 1];
		StdStrncpy(newString, prevCurrent, length);
		newString[length] = '\0';
		previousToken_ = nowToken_;
		nowToken_ = newString;
		delete[] newString;
		return nowToken_;
	}
	char* newString = new char[index + 1];
	StdStrncpy(newString, current_, index);
	newString[index] = '\0';
	previousToken_ = nowToken_;
	nowToken_ = newString;
	delete[] newString;
	current_ += index;
	return nowToken_;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
