//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * FPSv
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Utility/FPSMeasurement.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
FPSMeasurement::FPSMeasurement(){
	reset();
}
//------------------------------------------------------------------------------
// fXgN^
FPSMeasurement::~FPSMeasurement(){
}
//------------------------------------------------------------------------------
// Zbg
void FPSMeasurement::reset(){
	fps_ = 0.f;
	lastTime_ = Timer::getTick();
	frameCount_ = 0;
}
//------------------------------------------------------------------------------
// v
float FPSMeasurement::measurement(){
	Timer::Tick nowTime = Timer::getTick();
	float time = Timer::getInterval(lastTime_, nowTime);
	frameCount_++;
	// bς
	if(time > 1000.f){
		fps_ = frameCount_ * 1000.f / time;
		lastTime_ = nowTime;
		frameCount_ = 0;
	}
	return fps_;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
