//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * FPSRg[
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Utility/FPSController.h"
#include "Core/Thread/Thread.h"
#include "Core/Thread/SynchronizedBlock.h"

namespace Lamp{

/// 60FPS
const float FPSController::interval60FPS = 16.6666666f;
/// 30FPS
const float FPSController::interval30FPS = 33.3333333f;

//------------------------------------------------------------------------------
// RXgN^
FPSController::FPSController(float targetInterval){
	setTargetInterval(targetInterval);
	tick_ = Timer::getTick();
}
//------------------------------------------------------------------------------
// fXgN^
FPSController::~FPSController(){
	Assert(backgroundThreads_.getCount() == 0);
}
//------------------------------------------------------------------------------
// FPSێ邽߂ɃJgXbhsleep
float FPSController::sleep(){
	// sleepԂ̎Zo
	intervalTime_ = Timer::getInterval(tick_);
	tick_ = Timer::getTick();
	sleepTime_ += (targetInterval_ - intervalTime_);
	if(sleepTime_ < 0.f){ sleepTime_ = 0.f; }
	else if(sleepTime_ > targetInterval_){ sleepTime_ = targetInterval_; }
	// C^[oXbh̍ĊJ
	bool hasBackgroundTask = false;
	{
		SynchronizedBlock synchronizedBlock(criticalSection_);
		if(backgroundThreads_.getCount() > 0){
			hasBackgroundTask = true;
			backgroundThreads_[0]->resume();
		}
	}
	// obNOEh^XNꍇ͍Œ1mssleep
	u_int correctedSleepTime = (u_int)sleepTime_;
	if(hasBackgroundTask && (correctedSleepTime == 0)){
		correctedSleepTime = 1;
	}
	Thread::sleep(correctedSleepTime);
	// C^[oXbh̒~
	{
		SynchronizedBlock synchronizedBlock(criticalSection_);
		if(hasBackgroundTask){
			Thread* backgroundThread = backgroundThreads_[0];
			if(backgroundThread->isFinished()){
				backgroundThreads_.remove(0);
			}else{
				backgroundThread->suspend();
			}
		}
	}
	return intervalTime_;
}
//------------------------------------------------------------------------------
// obNOEhXbh̓o^
void FPSController::registerBackgroundThread(Thread* backgroundThread){
	SynchronizedBlock synchronizedBlock(criticalSection_);
	Assert(!backgroundThread->isFinished());
	backgroundThreads_.pushBack(backgroundThread);
}
//------------------------------------------------------------------------------
// obNOEhXbh̎擾
int FPSController::getBackgroundThreadCount(){
	SynchronizedBlock synchronizedBlock(criticalSection_);
	return backgroundThreads_.getCount();
}
//------------------------------------------------------------------------------
// obNOEhXbh̎擾
Thread* FPSController::getBackgroundThread(int index){
	SynchronizedBlock synchronizedBlock(criticalSection_);
	return backgroundThreads_[index];
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String FPSController::toString() const{
	String result;
	result.format("interval %5.2f  sleep %5.2f  processing %5.2f%%",
		getIntervalTime(), getSleepTime(),
		getProcessingTime() / getIntervalTime() * 100.f);
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
