//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RtBO[Vt@C
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Utility/ConfigurationFile.h"
#include "Core/InputOutput/TextFileReader.h"
#include "Core/InputOutput/TextFileWriter.h"
#include "Core/InputOutput/TextConverter.h"
#include "Core/Utility/StringTokenizer.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
ConfigurationFile::ConfigurationFile(const String& fileName){
	load(fileName);
}
//------------------------------------------------------------------------------
// fXgN^
ConfigurationFile::~ConfigurationFile(){
	database_.clear();
}
//------------------------------------------------------------------------------
// [h
void ConfigurationFile::load(const String& fileName){
	fileName_ = fileName;
	TextFileReader reader(fileName_);
	String line;
	while(!reader.isEnd()){
		line = reader.readLine();
		StringTokenizer tokenizer(line, "\t");
		// sǂݔ΂
		if(!tokenizer.hasMoreTokens()){ continue; }
		String key = tokenizer.getNextToken();
		if(key.startsWith("//")){ continue; }
		Assert(tokenizer.hasMoreTokens());
		if(!tokenizer.hasMoreTokens()){ continue; }
		String value = tokenizer.getNextToken();
		add(key, value);
	}
}
//------------------------------------------------------------------------------
// f[^̒ǉ
void ConfigurationFile::add(const String& key, const String& value){
	Assert(!key.equals(""));
	Assert(key.getIndexOf('\n') == -1);
	Assert(key.getIndexOf('\t') == -1);
	Assert(!value.equals(""));
	Assert(value.getIndexOf('\n') == -1);
	Assert(value.getIndexOf('\t') == -1);
	database_.put(key, value);
}
//------------------------------------------------------------------------------
// charf[^̎擾
bool ConfigurationFile::getChar(const String& key, char* value) const{
	String valueString = database_.get(key);
	if(valueString.getSize() == 0){ return false; }
	return valueString.parseChar(value);
}
//------------------------------------------------------------------------------
// u_charf[^̎擾
bool ConfigurationFile::getUChar(const String& key, u_char* value) const{
	String valueString = database_.get(key);
	if(valueString.getSize() == 0){ return false; }
	return valueString.parseUChar(value);
}
//------------------------------------------------------------------------------
// shortf[^̎擾
bool ConfigurationFile::getShort(const String& key, short* value) const{
	String valueString = database_.get(key);
	if(valueString.getSize() == 0){ return false; }
	return valueString.parseShort(value);
}
//------------------------------------------------------------------------------
// u_shortf[^̎擾
bool ConfigurationFile::getUShort(const String& key, u_short* value) const{
	String valueString = database_.get(key);
	if(valueString.getSize() == 0){ return false; }
	return valueString.parseUShort(value);
}
//------------------------------------------------------------------------------
// intf[^̎擾
bool ConfigurationFile::getInt(const String& key, int* value) const{
	String valueString = database_.get(key);
	if(valueString.getSize() == 0){ return false; }
	return valueString.parseInt(value);
}
//------------------------------------------------------------------------------
// u_intf[^̎擾
bool ConfigurationFile::getUInt(const String& key, u_int* value) const{
	String valueString = database_.get(key);
	if(valueString.getSize() == 0){ return false; }
	return valueString.parseUInt(value);
}
//------------------------------------------------------------------------------
// floatf[^̎擾
bool ConfigurationFile::getFloat(const String& key, float* value) const{
	String valueString = database_.get(key);
	if(valueString.getSize() == 0){ return false; }
	return valueString.parseFloat(value);
}
//------------------------------------------------------------------------------
// doublef[^̎擾
bool ConfigurationFile::getDouble(const String& key, double* value) const{
	String valueString = database_.get(key);
	if(valueString.getSize() == 0){ return false; }
	return valueString.parseDouble(value);
}
//------------------------------------------------------------------------------
// Stringf[^̎擾
bool ConfigurationFile::getString(const String& key, String* value) const{
	String valueString = database_.get(key);
	if(valueString.getSize() == 0){ return false; }
	if(valueString.charAt(0) != '"'){ return false; }
	if(valueString.charAt(valueString.getSize() - 1) != '"'){ return false; }
	*value = TextConverter::textToString(valueString);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
