//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * EFCgZbg
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Thread/WaitSet.h"
#include "Core/Thread/CriticalSection.h"
#include "Core/Thread/Thread.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
WaitSet::WaitSet() : deleteLockObject_(true){
	lockObject_ = new CriticalSection();
}
//------------------------------------------------------------------------------
// RXgN^
WaitSet::WaitSet(LockObject* lockObject, bool deleteLockObject) :
	lockObject_(lockObject), deleteLockObject_(deleteLockObject){
	Assert(lockObject_ != NULL);
}
//------------------------------------------------------------------------------
// fXgN^
WaitSet::~WaitSet(){
	Assert(waitingThreads_.getCount() == 0);
	if(deleteLockObject_){ delete lockObject_; }
}
//------------------------------------------------------------------------------
// ҋ@
void WaitSet::wait(const Thread* thread){
	if(!isLockedByCurrentThread()){
		ErrorOut("WaitSet::wait() "
			"wait()邽߂ɂWaitSetɑ΂lock()Kvł");
	}
	HANDLE threadHandle = thread->getThreadHandle();
	waitingThreads_.pushBack(threadHandle);
	unlock();
	if(::SuspendThread(threadHandle) == 0xFFFFFFFF){
		ErrorOut("WaitSet::wait() SuspendThread()Ɏs܂");
	}
	lock();
}
//------------------------------------------------------------------------------
// ҋ@
void WaitSet::wait(){
	if(!isLockedByCurrentThread()){
		ErrorOut("WaitSet::wait() "
			"wait()邽߂ɂWaitSetɑ΂lock()Kvł");
	}
	// JgXbh̋[nhO[oȃnhɕϊ
	HANDLE threadHandle;
	if(::DuplicateHandle(::GetCurrentProcess(), ::GetCurrentThread(),
		::GetCurrentProcess(), &threadHandle,
		0, false, DUPLICATE_SAME_ACCESS) == 0){
		ErrorOut("WaitSet::wait() DuplicateHandle()Ɏs܂");
	}
	waitingThreads_.pushBack(threadHandle);
	unlock();
	if(::SuspendThread(threadHandle) == 0xFFFFFFFF){
		ErrorOut("WaitSet::wait() SuspendThread()Ɏs܂");
	}
	lock();
	// nh𕡐̂ŕĂ
	::CloseHandle(threadHandle);
}
//------------------------------------------------------------------------------
// ҋ@
void WaitSet::notify(){
	if(!isLockedByCurrentThread()){
		ErrorOut("WaitSet::notify() "
			"notify()邽߂ɂWaitSetɑ΂lock()Kvł");
	}
	if(waitingThreads_.getCount() == 0){ return; }
	HANDLE threadHandle = waitingThreads_.popFront();
	if(::ResumeThread(threadHandle) == 0xFFFFFFFF){
		ErrorOut("WaitSet::notify() ResumeThread()Ɏs܂");
	}
}
//------------------------------------------------------------------------------
// ҋ@S
void WaitSet::notifyAll(){
	if(!isLockedByCurrentThread()){
		ErrorOut("WaitSet::notifyAll() "
			"notifyAll()邽߂ɂWaitSetɑ΂lock()Kvł");
	}
	int threadCount = waitingThreads_.getCount();
	if(threadCount == 0){ return; }
	for(int i = 0; i < threadCount; i++){
		HANDLE threadHandle = waitingThreads_.get(i);
		if(::ResumeThread(threadHandle) == 0xFFFFFFFF){
			ErrorOut("WaitSet::notifyAll() ResumeThread()Ɏs܂");
		}
	}
	waitingThreads_.clear();
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
