//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Xbh
 * @author Junpee
 */

#include "LampBasic.h"
#include <process.h>
#include "Core/Thread/Thread.h"
#include "Core/Thread/SynchronizedBlock.h"

// timeBeginPeriod, timeEndPeriod
#include <windows.h>
#pragma comment(lib, "winmm.lib")

namespace Lamp{

/**
 * XbhR[obN
 * @param userData [Uf[^
 * @return IR[h
 */
u_int __stdcall threadCallback(void* userData){
	Thread* thread = (Thread*)userData;
	return thread->executeWrapper();
}

// sȃXbhnh
const HANDLE Thread::invalidThreadHandle = (HANDLE)-1L;

//------------------------------------------------------------------------------
// AI
//------------------------------------------------------------------------------
// 
void Thread::initialize(){
	// Windows^C}̐xグ
	::timeBeginPeriod(1);
}
//------------------------------------------------------------------------------
// n
void Thread::finalize(){
	// Windows^C}̐x
	::timeEndPeriod(1);
}
//------------------------------------------------------------------------------
// RXgN^
Thread::Thread() : Runnable(),
	threadHandle_(invalidThreadHandle), threadID_(0), isFinished_(false){
	runnable_ = this;
	createThread();
}
//------------------------------------------------------------------------------
// RXgN^
Thread::Thread(Runnable* runnable) : Runnable(),
	threadHandle_(invalidThreadHandle), threadID_(0), isFinished_(false){
	runnable_ = runnable;
	createThread();
}
//------------------------------------------------------------------------------
// RXgN^
Thread::Thread(LockObject* lockObject, bool deleteLockObject) :
	Runnable(lockObject, deleteLockObject),
	threadHandle_(invalidThreadHandle), threadID_(0), isFinished_(false){
	runnable_ = this;
	createThread();
}
//------------------------------------------------------------------------------
// RXgN^
Thread::Thread(
	Runnable* runnable, LockObject* lockObject, bool deleteLockObject) :
	Runnable(lockObject, deleteLockObject),
	threadHandle_(invalidThreadHandle), threadID_(0), isFinished_(false){
	runnable_ = runnable;
	createThread();
}
//------------------------------------------------------------------------------
// fXgN^
Thread::~Thread(){
	Assert(isFinished_);
}
//------------------------------------------------------------------------------
// Xbh̍쐬
void Thread::createThread(){
	// Ăꏊ炵Ă΂Ȃ̂œȂ
	Assert(threadHandle_ == invalidThreadHandle);
	Assert(threadID_ == 0);
	threadHandle_ = (HANDLE)::_beginthreadex(NULL, getStackSize(),
		threadCallback, this, CREATE_SUSPENDED, &threadID_);
	if(threadHandle_ == invalidThreadHandle){
		ErrorOut("Thread::createThread() _beginthreadex()Ɏs܂");
	}
	isFinished_ = false;
}
//------------------------------------------------------------------------------
// Xbh̑
//------------------------------------------------------------------------------
// XbhJn
void Thread::start(){
	// Xbhɑ΂郍bN
	SynchronizedBlock synchronizedBlock(this);
	// sIɍēxstartĂ΂ꂽꍇ̓Xbhč쐬
	if(isFinished_){ createThread(); }
	Assert(getThreadHandle() != invalidThreadHandle);
	Assert(getThreadID() != 0);
	if(::ResumeThread(getThreadHandle()) == 0xFFFFFFFF){
		ErrorOut("Thread::start() ResumeThread()Ɏs܂");
	}
}
//------------------------------------------------------------------------------
// XbhZbgAbv
void Thread::setup(){
	// Xbhɑ΂郍bN
	SynchronizedBlock synchronizedBlock(this);
	// sIɍēxstartĂ΂ꂽꍇ̓Xbhč쐬
	if(isFinished_){ createThread(); }
	Assert(getThreadHandle() != invalidThreadHandle);
	Assert(getThreadID() != 0);
}
//------------------------------------------------------------------------------
// Xbh̏I˗
void Thread::requestStop(){
	// Xbhɑ΂郍bN
	SynchronizedBlock synchronizedBlock(this);
	if(isFinished()){ return; }
	Assert(getThreadHandle() != invalidThreadHandle);
	Assert(getThreadID() != 0);
	runnable_->setStopRequested(true);
}
//------------------------------------------------------------------------------
// Xbh̏I˗AI҂
bool Thread::stop(u_int milliseconds){
	if(isFinished()){ return true; }
	requestStop();
	return join(milliseconds);
}
//------------------------------------------------------------------------------
// Xbh̏I҂
bool Thread::join(u_int milliseconds){
	// bNƃfbhbNɂȂ
	if(isFinished()){ return true; }
	Assert(getThreadHandle() != invalidThreadHandle);
	Assert(getThreadID() != 0);
	u_int result = ::WaitForSingleObject(getThreadHandle(), milliseconds);
	if(result == WAIT_OBJECT_0){
		return true;
	}else if(result == WAIT_TIMEOUT){
		return false;
	}else if(result == WAIT_ABANDONED){
		ErrorOut("Thread::join() Mutexێ܂ThreadI܂");
	}else if(result == WAIT_FAILED){
		Assert(false);
		return false;
//		DebugOut("%d\n", GetLastError());
//		ErrorOut("Thread::join() WaitForSingleObject()Ɏs܂");
	}
	return true;
}
//------------------------------------------------------------------------------
// vCIeB̐ݒ
void Thread::setPriority(Priority priority){
	Assert(getThreadHandle() != invalidThreadHandle);
	Assert(getThreadID() != 0);
	// Xbhɑ΂郍bN
	SynchronizedBlock synchronizedBlock(this);
	if(SetThreadPriority(getThreadHandle(), priority) == 0){
		ErrorOut("Thread::setPriority() SetThreadPriority()Ɏs܂");
	}
}
//------------------------------------------------------------------------------
// vCIeB̎擾
Thread::Priority Thread::getPriority(){
	Assert(getThreadHandle() != invalidThreadHandle);
	Assert(getThreadID() != 0);
	// Xbhɑ΂郍bN
	SynchronizedBlock synchronizedBlock(this);
	int result = GetThreadPriority(getThreadHandle());
	if(result == THREAD_PRIORITY_ERROR_RETURN){
		ErrorOut("Thread::getPriority() GetThreadPriority()Ɏs܂");
	}
	return (Priority)result;
}
//------------------------------------------------------------------------------
// TXyh
void Thread::suspend(){
	// Xbhɑ΂郍bN
	SynchronizedBlock synchronizedBlock(this);
	if(isFinished()){ return; }
	Assert(::GetCurrentThreadId() != getThreadID());
	if(::SuspendThread(getThreadHandle()) == 0xFFFFFFFF){
		ErrorOut("Thread::suspend() SuspendThread()Ɏs܂");
	}
}
//------------------------------------------------------------------------------
// W[
void Thread::resume(){
	// Xbhɑ΂郍bN
	SynchronizedBlock synchronizedBlock(this);
	if(isFinished()){ return; }
	if(::ResumeThread(getThreadHandle()) == 0xFFFFFFFF){
		ErrorOut("Thread::resume() ResumeThread()Ɏs܂");
	}
}
//------------------------------------------------------------------------------
// gps
//------------------------------------------------------------------------------
// Xbh̎sbp
u_int Thread::executeWrapper(){
	// Jn
	{
		// Xbhɑ΂郍bN
		SynchronizedBlock synchronizedBlock(this);
		runnable_->setStopRequested(false);
	}
	// s
	runnable_->run(this);
	// I
	{
		// Xbhɑ΂郍bN
		SynchronizedBlock synchronizedBlock(this);
		isFinished_ = true;
		::CloseHandle(getThreadHandle());
		threadHandle_ = invalidThreadHandle;
		threadID_ = 0; 
	}
	return 0;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
