//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * 3Dw
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/System/Math3D.h"

namespace Lamp{

//------------------------------------------------------------------------------
// @̌vZ
Vector3 Math3D::calculateNormal(const Vector3& vertex0,
	const Vector3& vertex1, const Vector3& vertex2){
	Vector3 edge0(vertex1), edge1(vertex2);
	edge0 -= vertex0;
	edge1 -= vertex0;
	return edge0.crossProduct(edge1).normalize();
}
//------------------------------------------------------------------------------
// ZbNAbg]
Vector3 Math3D::lookAtZ(const Vector3& target){
	Vector3 direction(target);
	direction.normalize();
//	return Vector3(Math::asin(direction.y),
//		Math::atan2(direction.x, direction.z), 0.f);
	return Vector3(Math::asin(-direction.y),
		Math::atan2(direction.x, direction.z), 0.f);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
