//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * w
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/System/Math.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
// pC
const float Math::PI = (float)3.14159265358979323846;

// pC * 4
const float Math::quadruplePI = (float)(3.14159265358979323846 * 4.);

// pC * 2
const float Math::doublePI = (float)(3.14159265358979323846 * 2.);

// pC / 2
const float Math::halfPI = (float)(3.14159265358979323846 / 2.);

// pC / 4
const float Math::quadrantPI = (float)(3.14159265358979323846 / 4.);

// Rΐ̒
const float Math::E = 2.71828182845904523536f;

// CvV
const float Math::epsilon = 1e-06f;

//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
