//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Lamp
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/System/LampCore.h"
#include "Graphics/System/LampGraphics.h"
#include "Input/System/LampInput.h"
#include "Core/Utility/Timer.h"
#include "Core/Thread/Thread.h"

namespace Lamp{

// tO
bool LampCore::isInitialized_ = false;

//------------------------------------------------------------------------------
// 
void LampCore::initialize(){
	// ς݂Ȃ疳
	if(isInitialized_){ return; }
	// 
	MemoryChecker::initialize();
	// G[o͏
//	ErrorOutInitialize();
	ErrorOutInitialize(NULL);
	// fobOo͏
	DebugOutInitialize();
	// Xbh
	Thread::initialize();
	// ^C}
	Timer::initialize();
	// tOĂ
	isInitialized_ = true;
}
//------------------------------------------------------------------------------
// n
void LampCore::finalize(){
	// Xbhn
	Thread::finalize();
	// fobOo͌n
	DebugOutFinalize();
	// G[o͌n
	ErrorOutFinalize();
	// tONA
	isInitialized_ = false;
}
//------------------------------------------------------------------------------
// EBhEvV[W
LRESULT LampCore::windowProcedure(
	HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam){
	LRESULT result;
	// OtBbNX̃vV[WĂ
	result = LampGraphics::windowProcedure(
		windowHandle, message, wParam, lParam);
	if(result != 0){ return result; }

	// ͂̃vV[WĂ
	result = LampInput::windowProcedure(
		windowHandle, message, wParam, lParam);
	if(result != 0){ return result; }

	// bZ[W̏
	switch(message){
	// AvP[VI
	case WM_CLOSE:
		PostQuitMessage(0);
		break;
	}
	return 0;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
