//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * io[l[}
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Renamer/NumberRenamer.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
NumberRenamer::NumberRenamer(){
}
//------------------------------------------------------------------------------
// fXgN^
NumberRenamer::~NumberRenamer(){
}
//------------------------------------------------------------------------------
// l[
String NumberRenamer::rename(Database* database, const String& sourceName){
	// '_'ȍ~폜
	String result = sourceName;
	int underBarIndex = result.getIndexOf('_');
	Assert(underBarIndex != 0);
	if(underBarIndex > 0){
		result = result.getSubstring(0, underBarIndex);
	}
	// f̖O݂邩ǂ
	if(!database->existName(result)){ return result; }
	// ioOs
	int counter = 0;
	String resultName;
	while(true){
		resultName.format("%s_%x",
			result.getBytes(), counter);
		if(!database->existName(resultName)){ break; }
		counter++;
	}
	return resultName;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
