//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * JEgl[}
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Renamer/CountRenamer.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
CountRenamer::CountRenamer() : count_(0){
}
//------------------------------------------------------------------------------
// RXgN^
CountRenamer::CountRenamer(u_int count) : count_(count){
}
//------------------------------------------------------------------------------
// fXgN^
CountRenamer::~CountRenamer(){
}
//------------------------------------------------------------------------------
// l[
String CountRenamer::rename(Database* database, const String& sourceName){
	// '_'ȍ~폜
	String result = sourceName;
	int underBarIndex = result.getIndexOf('_');
	Assert(underBarIndex != 0);
	if(underBarIndex > 0){
		result = result.getSubstring(0, underBarIndex);
	}
	// f̖O݂邩ǂ
	if(!database->existName(result)){ return result; }
	// ioOs
	String resultName;
	while(true){
		resultName.format("%s_%x",
			result.getBytes(), count_);
		if(!database->existName(resultName)){ break; }
		count_++;
	}
	return resultName;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
