//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eNX`W
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Primitive/TexCoord.h"

namespace Lamp{

// eNX`W^Cve[u
const String TexCoord::texCoordTypeStringTable[] = {
	"typeNone",
	"type1",
	"type2",
	"type3",
	"type4",
};

//------------------------------------------------------------------------------
// eNX`W^Cv當ւ̕ϊ
String TexCoord::texCoordTypeToString(Type texCoordType){
	Assert(texCoordType >= 0);
	Assert(texCoordType < typeMax);
	return texCoordTypeStringTable[texCoordType];
}
//------------------------------------------------------------------------------
// 񂩂eNX`W^Cvւ̕ϊ
TexCoord::Type TexCoord::texCoordTypeFromString(
	const String& texCoordTypeString){
	for(int i = 0; i < typeMax; i++){
		if(texCoordTypeStringTable[i].equals(texCoordTypeString)){
			return TexCoord::Type(i);
		}
	}
	ErrorOut("TexCoord::texCoordTypeFromString() " + texCoordTypeString);
	return typeMax;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
