//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * `
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Primitive/RectangleI.h"
#include "Core/Primitive/RectangleF.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
/// [`
const RectangleI RectangleI::zero(0, 0, 0, 0);

/// Pʋ`
const RectangleI RectangleI::unit(0, 0, 1, 1);

//------------------------------------------------------------------------------
// RXgN^
RectangleI::RectangleI(const RectangleF& source){
	x = (int)source.x;
	y = (int)source.y;
	width = (int)source.width;
	height = (int)source.height;
}
//------------------------------------------------------------------------------
// l̐ݒ
void RectangleI::set(const RectangleF& source){
	x = (int)source.x;
	y = (int)source.y;
	width = (int)source.width;
	height = (int)source.height;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
