//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * vfʒu
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Primitive/Point2i.h"
#include "Core/Primitive/Point2f.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
/// [ʒu
const Point2i Point2i::zero(0, 0);

/// Pʈʒu
const Point2i Point2i::unit(1, 1);

//------------------------------------------------------------------------------
// RXgN^
Point2i::Point2i(const Point2f& source) : x((int)source.x), y((int)source.y){
}
//------------------------------------------------------------------------------
// l̐ݒ
void Point2i::set(const Point2f& source){
	x = (int)source.x;
	y = (int)source.y;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
