//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * 3~3s
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Primitive/Matrix33.h"
#include "Core/Primitive/Matrix34.h"
#include "Core/Primitive/Matrix44.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
/// [s
const Matrix33 Matrix33::zero(
	0.f, 0.f, 0.f,
	0.f, 0.f, 0.f,
	0.f, 0.f, 0.f);

/// Pʍs
const Matrix33 Matrix33::unit(
	1.f, 0.f, 0.f,
	0.f, 1.f, 0.f,
	0.f, 0.f, 1.f);

//------------------------------------------------------------------------------
// 3~4s̐ݒ
void Matrix33::set(const Matrix34& source){
	set(source.m00, source.m01, source.m02,
		source.m10, source.m11, source.m12,
		source.m20, source.m21, source.m22);
}
//------------------------------------------------------------------------------
// 4~4s̐ݒ
void Matrix33::set(const Matrix44& source){
	set(source.m00, source.m01, source.m02,
		source.m10, source.m11, source.m12,
		source.m20, source.m21, source.m22);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
