//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * @
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Primitive/DimensionI.h"
#include "Core/Primitive/DimensionF.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
/// [@
const DimensionI DimensionI::zero(0, 0);

/// Pʐ@
const DimensionI DimensionI::unit(1, 1);

//------------------------------------------------------------------------------
// RXgN^
DimensionI::DimensionI(const DimensionF& source){
	width = (int)source.width;
	height = (int)source.height;
}
//------------------------------------------------------------------------------
// l̐ݒ
void DimensionI::set(const DimensionF& source){
	width = (int)source.width;
	height = (int)source.height;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
