//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * @
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Primitive/DimensionF.h"
#include "Core/Primitive/DimensionI.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
/// [@
const DimensionF DimensionF::zero(0.f, 0.f);

/// Pʐ@
const DimensionF DimensionF::unit(1.f, 1.f);

//------------------------------------------------------------------------------
// RXgN^
DimensionF::DimensionF(const DimensionI& source){
	width = (float)source.width;
	height = (float)source.height;
}
//------------------------------------------------------------------------------
// l̐ݒ
void DimensionF::set(const DimensionI& source){
	width = (float)source.width;
	height = (float)source.height;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
