//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * lvfJ[
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Primitive/Color4f.h"
#include "Core/Primitive/Color3c.h"
#include "Core/Primitive/Color4c.h"
#include "Core/Primitive/Color3f.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
// 
const Color4f Color4f::white(1.f, 1.f, 1.f);

// DF
const Color4f Color4f::gray(0.5f, 0.5f, 0.5f);

// 
const Color4f Color4f::black(0.f, 0.f, 0.f);

// 
const Color4f Color4f::red(1.f, 0.f, 0.f);

// 
const Color4f Color4f::green(0.f, 1.f, 0.f);

// 
const Color4f Color4f::blue(0.f, 0.f, 1.f);

// 
const Color4f Color4f::yellow(1.f, 1.f, 0.f);

// 
const Color4f Color4f::cyan(0.f, 1.f, 1.f);

// Ԏ
const Color4f Color4f::magenta(1.f, 0.f, 1.f);

//------------------------------------------------------------------------------
// RXgN^
Color4f::Color4f(const Color3c& source) :
	r(source.r / 255.f), g(source.g / 255.f), b(source.b / 255.f), a(1.f){
}
//------------------------------------------------------------------------------
// RXgN^
Color4f::Color4f(const Color4c& source) :
	r(source.r / 255.f), g(source.g / 255.f), b(source.b / 255.f),
	a(source.a / 255.f){
}
//------------------------------------------------------------------------------
// RXgN^
Color4f::Color4f(const Color3f& source) :
	r(source.r), g(source.g), b(source.b), a(1.f){
}
//------------------------------------------------------------------------------
// OvfLN^J[̐ݒ
void Color4f::set(const Color3c& source){
	set(source.r / 255.f, source.g / 255.f, source.b / 255.f, 1.f);
}
//------------------------------------------------------------------------------
// lvfLN^J[̐ݒ
void Color4f::set(const Color4c& source){
	set(source.r / 255.f, source.g / 255.f, source.b / 255.f, source.a / 255.f);
}
//------------------------------------------------------------------------------
// OvfJ[̐ݒ
void Color4f::set(const Color3f& source){
	set(source.r, source.g, source.b, 1.f);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
