//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OvfJ[
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Primitive/Color3f.h"
#include "Core/Primitive/Color3c.h"
#include "Core/Primitive/Color4c.h"
#include "Core/Primitive/Color4f.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
// 
const Color3f Color3f::white(1.f, 1.f, 1.f);

// DF
const Color3f Color3f::gray(0.5f, 0.5f, 0.5f);

// 
const Color3f Color3f::black(0.f, 0.f, 0.f);

// 
const Color3f Color3f::red(1.f, 0.f, 0.f);

// 
const Color3f Color3f::green(0.f, 1.f, 0.f);

// 
const Color3f Color3f::blue(0.f, 0.f, 1.f);

// 
const Color3f Color3f::yellow(1.f, 1.f, 0.f);

// 
const Color3f Color3f::cyan(0.f, 1.f, 1.f);

// Ԏ
const Color3f Color3f::magenta(1.f, 0.f, 1.f);

//------------------------------------------------------------------------------
// RXgN^
Color3f::Color3f(const Color3c& source) :
	r(source.r / 255.f), g(source.g / 255.f), b(source.b / 255.f){
}
//------------------------------------------------------------------------------
// RXgN^
Color3f::Color3f(const Color4c& source) :
	r(source.r / 255.f), g(source.g / 255.f), b(source.b / 255.f){
}
//------------------------------------------------------------------------------
// RXgN^
Color3f::Color3f(const Color4f& source) :
	r(source.r), g(source.g), b(source.b){
}
//------------------------------------------------------------------------------
// OvfLN^J[̐ݒ
void Color3f::set(const Color3c& source){
	set(source.r / 255.f, source.g / 255.f, source.b / 255.f);
}
//------------------------------------------------------------------------------
// lvfLN^J[̐ݒ
void Color3f::set(const Color4c& source){
	set(source.r / 255.f, source.g / 255.f, source.b / 255.f);
}
//------------------------------------------------------------------------------
// lvfJ[̐ݒ
void Color3f::set(const Color4f& source){
	set(source.r, source.g, source.b);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
