//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OvfLN^J[
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Primitive/Color3c.h"
#include "Core/Primitive/Color4c.h"
#include "Core/Primitive/Color3f.h"
#include "Core/Primitive/Color4f.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
// 
const Color3c Color3c::white(255, 255, 255);

// DF
const Color3c Color3c::gray(128, 128, 128);

// 
const Color3c Color3c::black(0, 0, 0);

// 
const Color3c Color3c::red(255, 0, 0);

// 
const Color3c Color3c::green(0, 255, 0);

// 
const Color3c Color3c::blue(0, 0, 255);

// 
const Color3c Color3c::yellow(255, 255, 0);

// 
const Color3c Color3c::cyan(0, 255, 255);

// Ԏ
const Color3c Color3c::magenta(255, 0, 255);

//------------------------------------------------------------------------------
// RXgN^
Color3c::Color3c(const Color4c& source) :
	r(source.r), g(source.g), b(source.b){
}
//------------------------------------------------------------------------------
// RXgN^
Color3c::Color3c(const Color3f& source){
	set(source);
}
//------------------------------------------------------------------------------
// RXgN^
Color3c::Color3c(const Color4f& source){
	set(source);
}
//------------------------------------------------------------------------------
// lvfLN^J[̐ݒ
void Color3c::set(const Color4c& source){
	set(source.r, source.g, source.b);
}
//------------------------------------------------------------------------------
// OvfJ[̐ݒ
void Color3c::set(const Color3f& source){
	int srcR = (int)(source.r * 255.f);
	if(srcR > 255){ srcR = 255; }
	else if(srcR < 0){ srcR = 0; }

	int srcG = (int)(source.g * 255.f);
	if(srcG > 255){ srcG = 255; }
	else if(srcG < 0){ srcG = 0; }

	int srcB = (int)(source.b * 255.f);
	if(srcB > 255){ srcB = 255; }
	else if(srcB < 0){ srcB = 0; }

	set(srcR, srcG, srcB);
}
//------------------------------------------------------------------------------
// lvfJ[̐ݒ
void Color3c::set(const Color4f& source){
	int srcR = (int)(source.r * 255.f);
	if(srcR > 255){ srcR = 255; }
	else if(srcR < 0){ srcR = 0; }

	int srcG = (int)(source.g * 255.f);
	if(srcG > 255){ srcG = 255; }
	else if(srcG < 0){ srcG = 0; }

	int srcB = (int)(source.b * 255.f);
	if(srcB > 255){ srcB = 255; }
	else if(srcB < 0){ srcB = 0; }

	set(srcR, srcG, srcB);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
