//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgC^
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/InputOutput/TextWriter.h"
#include "Core/System/StringMethod.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
TextWriter::TextWriter() : Writer(){
	bufferSize_ = defaultBufferSize;
	buffer_ = new char[bufferSize_];
}
//------------------------------------------------------------------------------
// fXgN^
TextWriter::~TextWriter(){
	delete[] buffer_;
}
//------------------------------------------------------------------------------
// eLXg̏o
void TextWriter::writeText(const String& text){
	writeText(text.getBytes(), text.getSize());
}
//------------------------------------------------------------------------------
// eLXg̏o
void TextWriter::writeText(const char* text){
	Assert(text != NULL);
	writeText(text, (int)StdStrlen(text));
}
//------------------------------------------------------------------------------
// eLXg̏o
// t@CȊÕXg[ɑ΂ĉsϊKvƂȂ̂ł
// ƃVvɂł
void TextWriter::writeText(const char* text, int size){
	Assert(text != NULL);
	// obt@̊g
	int maxSize = size * 2;
	if(maxSize > bufferSize_){
		delete[] buffer_;
		while(true){
			bufferSize_ *= 2;
			if(maxSize <= bufferSize_){ break; }
		}
		buffer_ = new char[bufferSize_];
	}
	// stB^
	int writeSize = 0;
	char preChar = ' ';
	for(int i = 0;i < size;i++){
		if((text[i] == '\n') && (preChar != '\r')){
			buffer_[writeSize] = '\r';
			writeSize++;
		}
		buffer_[writeSize] = text[i];
		preChar = text[i];
		writeSize++;
	}
	writeBytes(buffer_, writeSize);
}
//------------------------------------------------------------------------------
// tH[}bgeLXg̏o
void TextWriter::writeFormat(const char* format, ...){
	Assert(format != NULL);
	int formatBufferSize = formatDefaultBufferSize;
	char* formatBuffer;
	int writeSize;
	va_list args;
	va_start(args, format);
	while(true){
		formatBuffer = new char[formatBufferSize];
		writeSize = StdVsnprintf(formatBuffer, formatBufferSize, format, args);
		if(writeSize != -1){ break; }
		formatBufferSize *= 2;
		delete[] formatBuffer;
	}
	va_end(args);
	// NULLI[ĂȂ\邪薳
	writeText(formatBuffer, writeSize);
	delete[] formatBuffer;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
