//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXg[_
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/InputOutput/TextReader.h"
#include "Core/System/StringMethod.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
TextReader::TextReader(int bufferSize) : Reader(){
	bufferSize_ = bufferSize;
	buffer_ = new char[bufferSize_];
	output_ = new char[bufferSize_];
	position_ = bufferSize_;
}
//------------------------------------------------------------------------------
// fXgN^
TextReader::~TextReader(){
	SafeArrayDelete(output_);
	SafeArrayDelete(buffer_);
}
//------------------------------------------------------------------------------
// ̈sǂݍ
// ŃXg[łȂȂĂ
String TextReader::readLine(){
	// obt@̓ǂݍ
	if(position_ == bufferSize_){
		readSize_ = Math::minimum(bufferSize_, getSize());
		readBytes(buffer_, readSize_);
		// EOF΍
		filePosition_ = getPosition();
		setPosition(0);
		position_ = 0;
	}
	String returnString;
	int outputPosition = 0;
	while(true){
		char character = buffer_[position_];
		position_++;
		output_[outputPosition] = character;
		outputPosition++;
		// s
		bool breakFlag = false;
		if(character == '\n'){
			outputPosition--;
			output_[outputPosition] = '\0';
			breakFlag = true;
		}
		if(position_ == readSize_){
			// t@CI[
			if(readSize_ != bufferSize_){
				output_[outputPosition] = '\0';
				setPosition(filePosition_);
				break;
			}
			// obt@̓ǂݍ
			setPosition(filePosition_);
			readSize_ = Math::minimum(bufferSize_, getSize() - getPosition());
			// xǂݏI
			if(readSize_ == 0){
				output_[outputPosition] = '\0';
				setPosition(filePosition_);
				break;
			}
			readBytes(buffer_, readSize_);
			// EOF΍
			filePosition_ = getPosition();
			setPosition(0);
			position_ = 0;
			// o͕Ɍpďo͈ʒuNA
			output_[outputPosition] = '\0';
			returnString += output_;
			outputPosition = 0;
			output_[outputPosition] = '\0';
		}
		if(breakFlag){ break; }
	}
	// o
	if(output_[outputPosition - 1] == '\r'){
		output_[outputPosition - 1] = '\0';
	}
	returnString += output_;
	return returnString;
}
//------------------------------------------------------------------------------
// eLXg[_f[^̃Rs[
void TextReader::copyTextReaderData(TextReader* destination){
	::memcpy(destination->buffer_, buffer_, bufferSize_);
	::memcpy(destination->output_, output_, bufferSize_);
	destination->readSize_ = readSize_;
	destination->position_ = position_;
	destination->filePosition_ = filePosition_;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
