//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgRo[^
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/InputOutput/TextConverter.h"
#include "Core/System/StringMethod.h"

namespace Lamp{

//------------------------------------------------------------------------------
// StringeLXgւ̕ϊ
String TextConverter::stringToText(const String& string){
	int bufferSize = string.getSize() * 2 + 3;
	char* buffer = new char[bufferSize];
	char* current = buffer;
	*current = '\"';
	current++;
	const char* source = string.getBytes();
	while(true){
		char character = *source;
		if(character == '\0'){ break; }
		if(character == '\n'){
			*current = '\\';
			current++;
			*current = 'n';
			current++;
		}else if(character == '\t'){
			*current = '\\';
			current++;
			*current = 't';
			current++;
		}else if(character == '\\'){
			*current = '\\';
			current++;
			*current = '\\';
			current++;
		}else if(character == '\"'){
			*current = '\\';
			current++;
			*current = '\"';
			current++;
		}else if(character == '\r'){
			*current = '\\';
			current++;
			*current = 'r';
			current++;
		}else if(character == '\v'){
			*current = '\\';
			current++;
			*current = 'v';
			current++;
		}else if(character == '\b'){
			*current = '\\';
			current++;
			*current = 'b';
			current++;
		}else if(character == '\f'){
			*current = '\\';
			current++;
			*current = 'f';
			current++;
		}else if(character == '\a'){
			*current = '\\';
			current++;
			*current = 'a';
			current++;
		}else{
			// ̕֐i
			*current = *source;
			current++;
			const char* next = StdStrinc(source);
			if((next - source) == 2){// 2oCg
				source++;
				*current = *source;
				current++;
			}
		}
		source++;
	}
	*current = '\"';
	current++;
	*current = '\0';
	String returnString(buffer);
	delete[] buffer;
	return returnString;
}
//------------------------------------------------------------------------------
// eLXgStringւ̕ϊ
String TextConverter::textToString(const String& text){
	Assert('"' == text.charAt(0));
	Assert('"' == text.charAt(text.getSize() - 1));
	int bufferSize = text.getSize();// Œł2BNULLĂ-1B
	char* buffer = new char[bufferSize];
	char* current = buffer;
	const char* source = text.getBytes();
	// Õ_uNH[e[V
	source++;
	while(true){
		char character = *source;
		if(character == '\0'){ break; }
		if(character == '\\'){
			// GXP[vLN^
			source++;
			char escapeCharacter = *source;
			if(escapeCharacter == 'n'){
				*current = '\n';
				current++;
			}else if(escapeCharacter == 't'){
				*current = '\t';
				current++;
			}else if(escapeCharacter == '\\'){
				*current = '\\';
				current++;
			}else if(escapeCharacter == '\"'){
				*current = '\"';
				current++;
			}else if(escapeCharacter == 'r'){
				*current = '\r';
				current++;
			}else if(escapeCharacter == 'v'){
				*current = '\v';
				current++;
			}else if(escapeCharacter == 'b'){
				*current = '\b';
				current++;
			}else if(escapeCharacter == 'f'){
				*current = '\f';
				current++;
			}else if(escapeCharacter == 'a'){
				*current = '\a';
				current++;
			}else{
				AssertMessage(true,
					"TextConverter::textToString ΉGXP[vV[PX");
			}
		}else{
			// GXP[vLN^
			*current = *source;
			current++;
			const char* next = StdStrinc(source);
			if((next - source) == 2){// 2oCg
				source++;
				*current = *source;
				current++;
			}
		}
		source++;
	}
	// ̃_uNH[e[V
	current--;
	*current = '\0';
	String returnString(buffer);
	delete[] buffer;
	return returnString;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
