//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * o̓Xg[
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/InputOutput/MemoryOutputStream.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
MemoryOutputStream::MemoryOutputStream(int bufferInitialSize){
	bufferSize_ = bufferInitialSize;
	buffer_ = new char[bufferSize_];
	size_ = position_ = 0;
}
//------------------------------------------------------------------------------
// fXgN^
MemoryOutputStream::~MemoryOutputStream(){
	delete[] buffer_;
}
//------------------------------------------------------------------------------
// obt@`FbN
void MemoryOutputStream::bufferCheck(int size){
	int newPosition = position_ + size;
	if(newPosition > bufferSize_){
		while(true){
			bufferSize_ *= 2;
			if(newPosition <= bufferSize_){ break; }
		}
		char* newBuffer = new char[bufferSize_];
		std::memcpy(newBuffer, buffer_, size_);
		delete[] buffer_;
		buffer_ = newBuffer;
	}
}
//------------------------------------------------------------------------------
// oCgf[^̏o
void MemoryOutputStream::writeBytes(const void* data, int size){
	bufferCheck(size);
	std::memcpy(buffer_ + position_, data, size);
	position_ += size;
	if(position_ > size_){ size_ = position_; }
}
//------------------------------------------------------------------------------
// TCY̎擾
int MemoryOutputStream::getSize(){
	return size_;
}
//------------------------------------------------------------------------------
// XLbv
void MemoryOutputStream::skip(int size){
	bufferCheck(size);
	std::memset(buffer_ + position_, 0, size);
	position_ += size;
	if(position_ > size_){ size_ = position_; }
}
//------------------------------------------------------------------------------
// ACg
int MemoryOutputStream::align(int alignSize){
	int size = position_ % alignSize;
	if(size== 0){ return size; }
	size = alignSize - size;
	bufferCheck(size);
	std::memset(buffer_ + position_, 0, size);
	position_ += size;
	if(position_ > size_){ size_ = position_; }
	return size;
}
//------------------------------------------------------------------------------
// ݈ʒu̎擾
int MemoryOutputStream::getPosition(){
	return position_;
}
//------------------------------------------------------------------------------
// ݈ʒu̐ݒ
void MemoryOutputStream::setPosition(int position){
	Assert(position >= 0);
	Assert(position <= size_);
	position_ = position;
}
//------------------------------------------------------------------------------
// tbV
void MemoryOutputStream::flush(){
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
