//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ̓Xg[
 * @author Junpee
 */

#include <stdio.h>
#include "LampBasic.h"
#include "Core/InputOutput/MemoryInputStream.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
MemoryInputStream::MemoryInputStream(const char* buffer, int size) :
	buffer_(buffer), size_(size), position_(0){
}
//------------------------------------------------------------------------------
// fXgN^
MemoryInputStream::~MemoryInputStream(){
}
//------------------------------------------------------------------------------
// ̓Xg[̕
MemoryInputStream* MemoryInputStream::cloneMemoryInputStream(){
	MemoryInputStream* memoryInputStream =
		new MemoryInputStream(buffer_, size_);
	memoryInputStream->setPosition(getPosition());
	return memoryInputStream;
}
//------------------------------------------------------------------------------
// I[ǂ
bool MemoryInputStream::isEnd(){
	return (position_ == size_);
}
//------------------------------------------------------------------------------
// oCgf[^̓ǂݏo
void MemoryInputStream::readBytes(void* data, int size){
	Assert((position_ + size) <= size_);
	std::memcpy(data, buffer_ + position_, size);
	position_ += size;
}
//------------------------------------------------------------------------------
// TCY̎擾
int MemoryInputStream::getSize(){
	return size_;
}
//------------------------------------------------------------------------------
// XLbv
void MemoryInputStream::skip(int size){
	Assert((position_ + size) <= size_);
	position_ += size;
}
//------------------------------------------------------------------------------
// ACg
int MemoryInputStream::align(int alignSize){
	int size = position_ % alignSize;
	if(size == 0){ return size; }
	size = alignSize - size;
	Assert((position_ + size) <= size_);
	position_ += size;
	return size;
}
//------------------------------------------------------------------------------
// ǂݍ݈ʒu̎擾
int MemoryInputStream::getPosition(){
	return position_;
}
//------------------------------------------------------------------------------
// ǂݍ݈ʒu̐ݒ
void MemoryInputStream::setPosition(int position){
	Assert(position >= 0);
	Assert(position <= size_);
	position_ = position;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
