//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * t@CpX
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/InputOutput/FilePath.h"

namespace Lamp{

//------------------------------------------------------------------------------
// O̎擾
String FilePath::getName() const{
	String fileName = getFileName();
	int lastDotIndex = fileName.getLastIndexOf('.');
	if(lastDotIndex != -1){
		fileName = fileName.getSubstring(0, lastDotIndex);
	}
	return fileName;
}
//------------------------------------------------------------------------------
// t@C̎擾
String FilePath::getFileName() const{
	int dirIndex = path_.getLastIndexOf("/");
	int enIndex = path_.getLastIndexOf("\\");
	if(dirIndex < enIndex){ dirIndex = enIndex; }
	String fileName = path_;
	if(dirIndex != -1){
		fileName = path_.getSubstring(dirIndex + 1);
	}
	return fileName;
}
//------------------------------------------------------------------------------
// gq̎擾
String FilePath::getExtension() const{
	String extension;
	int lastDotIndex = path_.getLastIndexOf('.');
	if(lastDotIndex != -1){
		extension = path_.getSubstring(lastDotIndex + 1);
	}
	return extension.getLowerCase();
}
//------------------------------------------------------------------------------
// tH_pX̎擾
String FilePath::getFolderPath() const{
	String folderPath;
	int dirIndex = path_.getLastIndexOf("/");
	int enIndex = path_.getLastIndexOf("\\");
	if(dirIndex < enIndex){ dirIndex = enIndex; }
	if(dirIndex != -1){
		folderPath = path_.getSubstring(0, dirIndex + 1);
	}
	return folderPath;
}
//------------------------------------------------------------------------------
// t@C݂邩
bool FilePath::existFile() const{
	FILE* file = fopen(path_.getBytes(), "rb");
	if(file == NULL){ return false; }
	fclose(file);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
