//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * t@Co̓Xg[
 * @author Junpee
 */

#include <stdio.h>
#include "LampBasic.h"
#include "Core/InputOutput/FileOutputStream.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
FileOutputStream::FileOutputStream(String fileName) : position_(0), size_(0){
	file_ = fopen(fileName.getBytes(), "wbc");
	Assert(file_ != NULL);
}
//------------------------------------------------------------------------------
// fXgN^
FileOutputStream::~FileOutputStream(){
	int closeResult = fclose(file_);
	Assert(closeResult == 0);
}
//------------------------------------------------------------------------------
// oCgf[^̏o
void FileOutputStream::writeBytes(const void* data, int size){
	int result = (int)fwrite(data, 1, size, file_);
	Assert(result == size);
	position_ += size;
	if(position_ > size_){ size_ = position_; }
}
//------------------------------------------------------------------------------
// TCY̎擾
int FileOutputStream::getSize(){
	return size_;
}
//------------------------------------------------------------------------------
// XLbv
void FileOutputStream::skip(int size){
	for(int i = 0;i < size;i++){
		int result = fputc(0, file_);
		Assert(result != EOF);
	}
	position_ += size;
	if(position_ > size_){ size_ = position_; }
}
//------------------------------------------------------------------------------
// ACg
int FileOutputStream::align(int alignSize){
	int size = position_ % alignSize;
	if(size == 0){ return size; }
	size = alignSize - size;
	for(int i = 0;i < size;i++){
		int result = fputc(0, file_);
		Assert(result != EOF);
	}
	position_ += size;
	if(position_ > size_){ size_ = position_; }
	return size;
}
//------------------------------------------------------------------------------
// ݈ʒu̎擾
int FileOutputStream::getPosition(){
	return position_;
}
//------------------------------------------------------------------------------
// ݈ʒu̐ݒ
void FileOutputStream::setPosition(int position){
	int result = fseek(file_, position, SEEK_SET);
	Assert(result == 0);
	position_ = position;
}
//------------------------------------------------------------------------------
// tbV
void FileOutputStream::flush(){
	int result = fflush(file_);
	Assert(result == 0);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
