//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * t@C̓Xg[
 * @author Junpee
 */

#include <stdio.h>
#include "LampBasic.h"
#include "Core/InputOutput/FileInputStream.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
FileInputStream::FileInputStream(String fileName) :
	fileName_(fileName), position_(0){
	file_ = fopen(fileName_.getBytes(), "rb");
	Assert(file_ != NULL);
	// TCY̎Zo
	int result;
	result = fseek(file_, 0, SEEK_END);
	Assert(result == 0);
	size_ = ftell(file_);
	Assert(size_ != -1);
	fseek(file_, 0, SEEK_SET);
	Assert(result == 0);
}
//------------------------------------------------------------------------------
// fXgN^
FileInputStream::~FileInputStream(){
	int closeResult = fclose(file_);
	Assert(closeResult == 0);
}
//------------------------------------------------------------------------------
// t@C̓Xg[̕
FileInputStream* FileInputStream::cloneFileInputStream(){
	FileInputStream* fileInputStream = new FileInputStream(fileName_);
	fileInputStream->size_ = size_;
	fileInputStream->setPosition(getPosition());
	return fileInputStream;
}
//------------------------------------------------------------------------------
// I[ǂ
bool FileInputStream::isEnd(){
	return (position_ == size_);
}
//------------------------------------------------------------------------------
// oCgf[^̓ǂݏo
void FileInputStream::readBytes(void* data, int size){
	int result = (int)fread(data, 1, size, file_);
	Assert(result == size);
	position_ += size;
}
//------------------------------------------------------------------------------
// TCY̎擾
int FileInputStream::getSize(){
	return size_;
}
//------------------------------------------------------------------------------
// XLbv
void FileInputStream::skip(int size){
	position_ += size;
	int result = fseek(file_, position_, SEEK_SET);
	Assert(result == 0);
}
//------------------------------------------------------------------------------
// ACg
int FileInputStream::align(int alignSize){
	int size = position_ % alignSize;
	if(size == 0){ return size; }
	size = alignSize - size;
	position_ += size;
	int result = fseek(file_, position_, SEEK_SET);
	Assert(result == 0);
	return size;
}
//------------------------------------------------------------------------------
// ǂݍ݈ʒu̎擾
int FileInputStream::getPosition(){
	return position_;
}
//------------------------------------------------------------------------------
// ǂݍ݈ʒu̐ݒ
void FileInputStream::setPosition(int position){
	int result = fseek(file_, position, SEEK_SET);
	Assert(result == 0);
	position_ = position;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
