//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oCiC^
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/InputOutput/BinaryWriter.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
BinaryWriter::BinaryWriter() : Writer(){
}
//------------------------------------------------------------------------------
// fXgN^
BinaryWriter::~BinaryWriter(){
}
//------------------------------------------------------------------------------
// bool̏o
void BinaryWriter::writeBool(bool value){
	writeBytes(&value, sizeof(bool));
}
//------------------------------------------------------------------------------
// chaȑo
void BinaryWriter::writeChar(char value){
	writeBytes(&value, sizeof(char));
}
//------------------------------------------------------------------------------
// u_chaȑo
void BinaryWriter::writeUChar(u_char value){
	writeBytes(&value, sizeof(u_char));
}
//------------------------------------------------------------------------------
// short̏o
void BinaryWriter::writeShort(short value){
	writeBytes(&value, sizeof(short));
}
//------------------------------------------------------------------------------
// u_short̏o
void BinaryWriter::writeUShort(u_short value){
	writeBytes(&value, sizeof(u_short));
}
//------------------------------------------------------------------------------
// int̏o
void BinaryWriter::writeInt(int value){
	writeBytes(&value, sizeof(int));
}
//------------------------------------------------------------------------------
// u_int̏o
void BinaryWriter::writeUInt(u_int value){
	writeBytes(&value, sizeof(u_int));
}
//------------------------------------------------------------------------------
// float̏o
void BinaryWriter::writeFloat(float value){
	writeBytes(&value, sizeof(float));
}
//------------------------------------------------------------------------------
// doublȅo
void BinaryWriter::writeDouble(double value){
	writeBytes(&value, sizeof(double));
}
//------------------------------------------------------------------------------
// String̏o
void BinaryWriter::writeString(const String& string){
	int size = string.getSize();
	writeBytes(&size, sizeof(int));
	writeBytes(string.getBytes(), size);
}
//------------------------------------------------------------------------------
// z̏o
void BinaryWriter::writeArray(
	const void* array, int elementSize, int elementCount){
	writeBytes(array, elementSize * elementCount);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
