//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oCi[_
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/InputOutput/BinaryReader.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
BinaryReader::BinaryReader() : Reader(){
}
//------------------------------------------------------------------------------
// fXgN^
BinaryReader::~BinaryReader(){
}
//------------------------------------------------------------------------------
// bool̓ǂݍ
bool BinaryReader::readBool(){
	bool value;
	readBytes(&value, sizeof(bool));
	return value;
}
//------------------------------------------------------------------------------
// char̓ǂݍ
char BinaryReader::readChar(){
	char value;
	readBytes(&value, sizeof(char));
	return value;
}
//------------------------------------------------------------------------------
// u_char̓ǂݍ
u_char BinaryReader::readUChar(){
	u_char value;
	readBytes(&value, sizeof(u_char));
	return value;
}
//------------------------------------------------------------------------------
// short̓ǂݍ
short BinaryReader::readShort(){
	short value;
	readBytes(&value, sizeof(short));
	return value;
}
//------------------------------------------------------------------------------
// u_short̓ǂݍ
u_short BinaryReader::readUShort(){
	u_short value;
	readBytes(&value, sizeof(u_short));
	return value;
}
//------------------------------------------------------------------------------
// int̓ǂݍ
int BinaryReader::readInt(){
	int value;
	readBytes(&value, sizeof(int));
	return value;
}
//------------------------------------------------------------------------------
// u_int̓ǂݍ
u_int BinaryReader::readUInt(){
	u_int value;
	readBytes(&value, sizeof(u_int));
	return value;
}
//------------------------------------------------------------------------------
// float̓ǂݍ
float BinaryReader::readFloat(){
	float value;
	readBytes(&value, sizeof(float));
	return value;
}
//------------------------------------------------------------------------------
// double̓ǂݍ
double BinaryReader::readDouble(){
	double value;
	readBytes(&value, sizeof(double));
	return value;
}
//------------------------------------------------------------------------------
// String̓ǂݍ
const String BinaryReader::readString(){
	int value;
	readBytes(&value, sizeof(int));
	char* buffer = new char[value + 1];
	readBytes(buffer, value);
	buffer[value] = '\0';
	String returnString(buffer);
	delete[] buffer;
	return returnString;
}
//------------------------------------------------------------------------------
// z̓ǂݍ
void BinaryReader::readArray(
	void* array, int elementSize, int elementCount){
	readBytes(array, elementSize * elementCount);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
