//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * `FbJ
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Debug/MemoryChecker.h"
#include "Core/Debug/DebugOutput.h"

// fobÔ݋@\܂B
#ifdef _DEBUG

namespace Lamp{

// tO
bool MemoryChecker::initialized_ = false;

//------------------------------------------------------------------------------
// `FbJ
void MemoryChecker::initialize(){
	if(initialized_){ return; }
	// vOIɃ[N`FbNB
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);
	// [jOAG[AAT[gfobOo͂ɏoB
	_CrtSetReportMode(_CRT_WARN, _CRTDBG_MODE_DEBUG);
	_CrtSetReportMode(_CRT_ERROR, _CRTDBG_MODE_DEBUG);
	_CrtSetReportMode(_CRT_ASSERT, _CRTDBG_MODE_DEBUG);
	initialized_ = true;
}
//------------------------------------------------------------------------------
// Xe[g̎擾
MemoryChecker::State MemoryChecker::getState(){
	State state;
	_CrtMemCheckpoint(&state.state);
	return state;
}
//------------------------------------------------------------------------------
// ڍ׃_v
void MemoryChecker::dumpDetail(){
	_CrtMemDumpAllObjectsSince(NULL);
}
//------------------------------------------------------------------------------
// ڍׂ̍_v
void MemoryChecker::dumpDetail(const State& oldState){
	_CrtMemDumpAllObjectsSince(&oldState.state);
}
//------------------------------------------------------------------------------
// ṽ_v
void MemoryChecker::dumpStatistics(){
	State state;
	_CrtMemCheckpoint(&state.state);
	_CrtMemDumpStatistics(&state.state);
}
//------------------------------------------------------------------------------
// v̍_v
void MemoryChecker::dumpStatistics(const State& oldState){
	State newState, diffState;
	_CrtMemCheckpoint(&newState.state);
	_CrtMemDifference(&diffState.state, &oldState.state, &newState.state);
	_CrtMemDumpStatistics(&diffState.state);
}
//------------------------------------------------------------------------------
// [N`FbN
bool MemoryChecker::leakCheck(const State& oldState){
	State newState, diffState;
	_CrtMemCheckpoint(&newState.state);
	if(_CrtMemDifference(&diffState.state, &oldState.state, &newState.state)){
		DebugOutThickLine();
		DebugOut("!!! [N !!!\n");
		DebugOutLine();
		_CrtMemDumpAllObjectsSince(&diffState.state);
		DebugOutLine();
		_CrtMemDumpStatistics(&diffState.state);
		DebugOutLine();
		DebugOut("!!! [N !!!\n");
		DebugOutThickLine();
		return true;
	}
	return false;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of _DEBUG
//------------------------------------------------------------------------------
