//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * K[
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Debug/Logger.h"
#include "Core/InputOutput/TextFileWriter.h"
#include "Core/System/StringMethod.h"
#include "Core/Debug/DebugStringTemporary.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
Logger::Logger(const String& fileName, LogLevel logLevel){
	writer_ = new TextFileWriter(fileName);
	logLevel_ = logLevel;
}
//------------------------------------------------------------------------------
// fXgN^
Logger::~Logger(){
	writer_->flush();
	SafeDelete(writer_);
}
//------------------------------------------------------------------------------
// Oo
void Logger::output(LogLevel logLevel, String message){
	Assert(logLevel != zeroLevel);
	if(logLevel == zeroLevel){ return; }
	if(logLevel_ < logLevel){ return; }
	writer_->writeText(message);
}
//------------------------------------------------------------------------------
// Oo
void Logger::output(LogLevel logLevel, const char* format, ...){
	Assert(logLevel != zeroLevel);
	if(logLevel == zeroLevel){ return; }
	if(logLevel_ < logLevel){ return; }
	va_list args;
	va_start(args, format);
	int size = StdVsnprintf(DebugStringTemporary::buffer_,
		DebugStringTemporary::bufferSize_ - 1, format, args);
	if(size < 0){
		ErrorOut(String("Oo͂̃tH[}bgɎs܂B"));
		return;
	}
	DebugStringTemporary::buffer_[size] = '\0';
	va_end(args);
	writer_->writeText(DebugStringTemporary::buffer_, size);
}
//------------------------------------------------------------------------------
// Oo
void Logger::output(const char* format, ...){
	if(logLevel_ < midiumLevel){ return; }
	va_list args;
	va_start(args, format);
	int size = StdVsnprintf(DebugStringTemporary::buffer_,
		DebugStringTemporary::bufferSize_ - 1, format, args);
	if(size < 0){
		ErrorOut(String("Oo͂̃tH[}bgɎs܂B"));
		return;
	}
	DebugStringTemporary::buffer_[size] = '\0';
	va_end(args);
	writer_->writeText(DebugStringTemporary::buffer_, size);
}
//------------------------------------------------------------------------------
// tbV
void Logger::flush(){
	writer_->flush();
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
