//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * G[o͎
 * @author Junpee
 */

#include <cstdlib>// exitɕKv
#include "LampBasic.h"
#include "Core/System/StringMethod.h"
#include "Core/Debug/ErrorOutput.h"
#include "Core/Debug/Logger.h"
#include "Core/Debug/DebugStringTemporary.h"
#include "Input/System/LampInput.h"
#include "Graphics/System/LampGraphics.h"

namespace Lamp{

// G[nh
ErrorOutput::ErrorHandler ErrorOutput::handler_ =
	ErrorOutput::defaultErrorHandler;

// K[
Logger* ErrorOutput::logger_ = NULL;

//------------------------------------------------------------------------------
// 
void ErrorOutput::initialize(const char* fileName){
	if(fileName == NULL){ return; }
	logger_ = new Logger(fileName);
}
//------------------------------------------------------------------------------
// n
void ErrorOutput::finalize(){
	SafeDelete(logger_);
}
//------------------------------------------------------------------------------
// fobO
#ifdef _DEBUG
//------------------------------------------------------------------------------
// G[o
int ErrorOutput::print(const char* format, ...){
	va_list args;
	va_start(args, format);
	int size = StdVsnprintf(DebugStringTemporary::buffer_,
		DebugStringTemporary::bufferSize_ - 1, format, args);
	if(size < 0){
		ErrorOut(String("G[o͂̃tH[}bgɎs܂B"));
		return size;
	}
	DebugStringTemporary::buffer_[size] = '\0';
	va_end(args);
	// ōDxŃK[֏o
	if(logger_ != NULL){
		logger_->output(
			Logger::fewLevel, String(DebugStringTemporary::buffer_));
		logger_->flush();
	}
	// ͂̃MOsĂΏIĂ
	if(LampInput::isLogging()){ LampInput::endLogging(); }
	// G[nȟĂяo
	(*handler_)(DebugStringTemporary::buffer_);
	return size;
}
//------------------------------------------------------------------------------
// G[o
int ErrorOutput::print(const String& string){
	// ōDxŃK[֏o
	if(logger_ != NULL){
		logger_->output(Logger::fewLevel, string);
		logger_->flush();
	}
	// ͂̃MOsĂΏIĂ
	if(LampInput::isLogging()){ LampInput::endLogging(); }
	// G[nȟĂяo
	(*handler_)(string.getBytes());
	return string.getSize();
}
//------------------------------------------------------------------------------
// ftHgG[nh
void ErrorOutput::defaultErrorHandler(const char* message){
	StdOutputDebugString("vIȃG[̂ŋI܂\n");
	StdOutputDebugString(message);
	StdOutputDebugString("\n");
	StdPrintf("vIȃG[̂ŋI܂\n%s\n", message);
	// fobKŒfB
	_asm{ int 3 }
	// bZ[Wo
	MessageBox(LampGraphics::getWindowHandle(), message,
		"vIȃG[̂ŋI܂",
		(MB_OK | MB_ICONERROR | MB_APPLMODAL));
	// VXeI
	std::exit(EXIT_FAILURE);
}
//------------------------------------------------------------------------------
// fobO
#else // ! _DEBUG
//------------------------------------------------------------------------------
// G[o
int ErrorOutput::print(const char* format, ...){
	va_list args;
	va_start(args, format);
	int size = StdVsnprintf(DebugStringTemporary::buffer_,
		DebugStringTemporary::bufferSize_ - 1, format, args);
	if(size < 0){
		ErrorOut("G[o͂̃tH[}bgɎs܂B");
		return size;
	}
	DebugStringTemporary::buffer_[size] = '\0';
	va_end(args);
	// ōDxŃK[֏o
	if(logger_ != NULL){
		logger_->output(Logger::fewLevel,
			String(DebugStringTemporary::buffer_));
		logger_->flush();
	}
	// ͂̃MOsĂΏIĂ
	if(LampInput::isLogging()){ LampInput::endLogging(); }
	// G[nȟĂяo
	(*handler_)(DebugStringTemporary::buffer_);
	return size;
}
//------------------------------------------------------------------------------
// G[o
int ErrorOutput::print(const String& string){
	// ōDxŃK[֏o
	if(logger_ != NULL){
		logger_->output(Logger::fewLevel, string);
		logger_->flush();
	}
	// ͂̃MOsĂΏIĂ
	if(LampInput::isLogging()){ LampInput::endLogging(); }
	// G[nȟĂяo
	(*handler_)(string.getBytes());
	return string.getSize();
}
//------------------------------------------------------------------------------
// ftHgG[nh
void ErrorOutput::defaultErrorHandler(const char* message){
	StdPrintf("vIȃG[̂ŋI܂\n%s\n", message);
	// bZ[Wo
	MessageBox(LampGraphics::getWindowHandle(), message,
		"vIȃG[̂ŋI܂",
		(MB_OK | MB_ICONERROR | MB_APPLMODAL));
	// VXeI
	std::exit(EXIT_FAILURE);
}
//------------------------------------------------------------------------------
#endif// End of _DEBUG
} // End of namespace Lamp
//------------------------------------------------------------------------------
