//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * fobOo͎
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/System/StringMethod.h"
#include "Core/Debug/DebugOutput.h"
#include "Core/Debug/ErrorOutput.h"
#include "Core/Debug/Logger.h"
#include "Core/Debug/DebugStringTemporary.h"

// fobO
#ifdef _DEBUG

namespace Lamp{

// K[
Logger* DebugOutput::logger_ = NULL;

//------------------------------------------------------------------------------
// 
void DebugOutput::initialize(const char* fileName){
	if(fileName == NULL){ return; }
	logger_ = new Logger(fileName);
}
//------------------------------------------------------------------------------
// n
void DebugOutput::finalize(){
	SafeDelete(logger_);
}
//------------------------------------------------------------------------------
// fobOo
int DebugOutput::print(const char* format, ...){
	va_list args;
	va_start(args, format);
	int size = StdVsnprintf(DebugStringTemporary::buffer_,
		DebugStringTemporary::bufferSize_ - 1, format, args);
	if(size < 0){
		ErrorOut(String("fobOo͂̃tH[}bgɎs܂B"));
		return size;
	}
	DebugStringTemporary::buffer_[size] = '\0';
	va_end(args);
	StdOutputDebugString(DebugStringTemporary::buffer_);
	StdPrintf(DebugStringTemporary::buffer_);
	// ōDxŃK[֏o
	if(logger_ != NULL){
		logger_->output(
			Logger::fewLevel, String(DebugStringTemporary::buffer_));
	}
	return size;
}
//------------------------------------------------------------------------------
// fobOo
int DebugOutput::print(const String& string){
	StdOutputDebugString(string.getBytes());
	StdPrintf(string.getBytes());
	// ōDxŃK[֏o
	if(logger_ != NULL){
		logger_->output(Logger::fewLevel, string);
	}
	return string.getSize();
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif// End of _DEBUG
//------------------------------------------------------------------------------
