//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TargaZ[o
 * @author Junpee
 */

#include "LampBasic.h"
#include "Core/Codec/Tga/TargaSaver.h"
#include "Core/InputOutput/BinaryFileWriter.h"

namespace Lamp{

// tb^
const char TargaSaver::footer_[] = "TRUEVISION-XFILE.";

//------------------------------------------------------------------------------
// RXgN^
TargaSaver::TargaSaver(){
}
//------------------------------------------------------------------------------
// fXgN^
TargaSaver::~TargaSaver(){
}
//------------------------------------------------------------------------------
// Z[u
void TargaSaver::save(
	BinaryWriter* writer, const DimensionI& size, const Color3c* colors){
	writer_ = writer;
	size_ = size;
	// At@wb_̏o
	writeHeader(false);
	// C[W̏o
	int bufferSize = size_.width * size_.height * sizeof(Color3c);
	u_char* buffer = new u_char[bufferSize];
	u_char* writeAddress = buffer;
	for(int i = size_.height - 1; i >= 0; i--){
		int offset = i * size_.width;
		for(int j = 0; j < size_.width; j++){
			const Color3c& color = colors[offset + j];
			*writeAddress = color.b;
			writeAddress++;
			*writeAddress = color.g;
			writeAddress++;
			*writeAddress = color.r;
			writeAddress++;
		}
	}
	writer_->writeBytes(buffer, bufferSize);
	delete[] buffer;
	// tb^o
	writeFooter();
}
//------------------------------------------------------------------------------
// Z[u
void TargaSaver::save(
	BinaryWriter* writer, const DimensionI& size, const Color4c* colors){
	writer_ = writer;
	size_ = size;
	// At@Lwb_̏o
	writeHeader(true);
	// C[W̏o
	int bufferSize = size_.width * size_.height * sizeof(Color4c);
	u_char* buffer = new u_char[bufferSize];
	u_char* writeAddress = buffer;
	for(int i = size_.height - 1; i >= 0; i--){
		int offset = i * size_.width;
		for(int j = 0; j < size_.width; j++){
			const Color4c& color = colors[offset + j];
			*writeAddress = color.b;
			writeAddress++;
			*writeAddress = color.g;
			writeAddress++;
			*writeAddress = color.r;
			writeAddress++;
			*writeAddress = color.a;
			writeAddress++;
		}
	}
	writer_->writeBytes(buffer, bufferSize);
	delete[] buffer;
	// tb^o
	writeFooter();
}
//------------------------------------------------------------------------------
// Z[u
void TargaSaver::save(
	BinaryWriter* writer, int width, int height, const Color3c* colors){
	save(writer, DimensionI(width, height), colors);
}
//------------------------------------------------------------------------------
// Z[u
void TargaSaver::save(
	BinaryWriter* writer, int width, int height, const Color4c* colors){
	save(writer, DimensionI(width, height), colors);
}
//------------------------------------------------------------------------------
// Z[u
void TargaSaver::save(
	const String& filePath, const DimensionI& size, const Color3c* colors){
	BinaryFileWriter* binaryFileWriter = new BinaryFileWriter(filePath);
	save(binaryFileWriter, size, colors);
	delete binaryFileWriter;
}
//------------------------------------------------------------------------------
// Z[u
void TargaSaver::save(
	const String& filePath, const DimensionI& size, const Color4c* colors){
	BinaryFileWriter* binaryFileWriter = new BinaryFileWriter(filePath);
	save(binaryFileWriter, size, colors);
	delete binaryFileWriter;
}
//------------------------------------------------------------------------------
// Z[u
void TargaSaver::save(
	const String& filePath, int width, int height, const Color3c* colors){
	BinaryFileWriter* binaryFileWriter = new BinaryFileWriter(filePath);
	save(binaryFileWriter, DimensionI(width, height), colors);
	delete binaryFileWriter;
}
//------------------------------------------------------------------------------
// Z[u
void TargaSaver::save(
	const String& filePath, int width, int height, const Color4c* colors){
	BinaryFileWriter* binaryFileWriter = new BinaryFileWriter(filePath);
	save(binaryFileWriter, DimensionI(width, height), colors);
	delete binaryFileWriter;
}
//------------------------------------------------------------------------------
// wb_̏o
void TargaSaver::writeHeader(bool hasAlpha){
	// C[WID
	writer_->writeUChar(0);
	// J[}bvΉ
	writer_->writeUChar(0);
	// C[W^Cv̓J[}bv񈳏kRGB
	writer_->writeUChar(2);
	// J[}bvڍ׏񖳂
	writer_->writeShort(0);
	writer_->writeShort(0);
	writer_->writeUChar(0);
	// XJn_
	writer_->writeShort(0);
	// YJn_
	writer_->writeShort(0);
	// 
	writer_->writeShort(size_.width);
	// 
	writer_->writeShort(size_.height);
	if(hasAlpha){
		// sNZTCY
		writer_->writeUChar(32);
		// At@[x
		writer_->writeUChar(8);
	}else{
		// sNZTCY
		writer_->writeUChar(24);
		// At@[x
		writer_->writeUChar(0);
	}
}
//------------------------------------------------------------------------------
// tb^̏o
void TargaSaver::writeFooter(){
	writer_->writeUInt(0);
	writer_->writeUInt(0);
	writer_->writeBytes(footer_, 18);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
