//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RW[t
 * @author Junpee
 */

#include "LampBasic.h"
#include "Collision/System/CollisionLeaf.h"
#include "Collision/System/CollisionScene.h"
#include "Collision/System/CollisionNode.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
CollisionLeaf::CollisionLeaf(const String& name, CollisionScene* scene) :
	CollisionObject(name, scene), collisionMask_(1){
	setGlobalEnabled(false);
}
//------------------------------------------------------------------------------
// fXgN^
CollisionLeaf::~CollisionLeaf(){
}
//------------------------------------------------------------------------------
// j
int CollisionLeaf::destroy(CollisionLeaf* collisionLeaf){
	Assert(collisionLeaf != NULL);
	// e폜
	CollisionNode* parent = collisionLeaf->getParent();
	if(parent != NULL){ parent->removeChild(collisionLeaf); }
	// ̔j
	collisionLeaf->getScene()->destroyLeaf(collisionLeaf);
	return 1;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// ̃ZbgAbv
bool CollisionLeaf::traverseSetup(bool parentEnabled, bool parentChanged){
	// O[oLtOݒ
	bool globalEnabled = (parentEnabled && isEnabled());
	setGlobalEnabled(globalEnabled);
	// O[oŗLŖȂ珈Ȃ
	if(!globalEnabled){ return false; }

	// O[oύXtOݒ
	bool globalChanged = (parentChanged || isChanged());
	setGlobalChanged(globalChanged);
	// ύXtÕZbg
	setChanged(false);
	// O[oŕύXȂ珈Ȃ
	if(!globalChanged){ return false; }

	return true;
}
//------------------------------------------------------------------------------
// XP[
//------------------------------------------------------------------------------
// XP[̐ݒ
void CollisionLeaf::setScale(const Vector3& scale){
	Assert(getParent() != NULL);
	getParent()->setScale(scale);
}
//------------------------------------------------------------------------------
// XP[̎擾
const Vector3& CollisionLeaf::getScale() const{
	Assert(getParent() != NULL);
	return getParent()->getScale();
}
//------------------------------------------------------------------------------
// XP[gpĂ邩
bool CollisionLeaf::isScaled() const{
	Assert(getParent() != NULL);
	return getParent()->isScaled();
}
//------------------------------------------------------------------------------
// O[oŃXP[gpĂ邩
bool CollisionLeaf::isGlobalScaled() const{
	Assert(getParent() != NULL);
	return getParent()->isGlobalScaled();
}
//------------------------------------------------------------------------------
// ]
//------------------------------------------------------------------------------
// XYZ]̐ݒ
void CollisionLeaf::setRotationXYZ(const Vector3& rotation){
	Assert(getParent() != NULL);
	getParent()->setRotationXYZ(rotation);
}
//------------------------------------------------------------------------------
// XYZ]̎擾
const Vector3& CollisionLeaf::getRotationXYZ(){
	Assert(getParent() != NULL);
	return getParent()->getRotationXYZ();
}
//------------------------------------------------------------------------------
// l]̐ݒ
void CollisionLeaf::setRotationQuaternion(const Quaternion& rotation){
	Assert(getParent() != NULL);
	getParent()->setRotationQuaternion(rotation);
}
//------------------------------------------------------------------------------
// l]̎擾
const Quaternion& CollisionLeaf::getRotationQuaternion(){
	Assert(getParent() != NULL);
	return getParent()->getRotationQuaternion();
}
//------------------------------------------------------------------------------
// ړ
//------------------------------------------------------------------------------
// ړ̐ݒ
void CollisionLeaf::setTranslation(const Vector3& translation){
	Assert(getParent() != NULL);
	getParent()->setTranslation(translation);
}
//------------------------------------------------------------------------------
// ړ̎擾
const Vector3& CollisionLeaf::getTranslation() const{
	Assert(getParent() != NULL);
	return getParent()->getTranslation();
}
//------------------------------------------------------------------------------
// s
//------------------------------------------------------------------------------
// [hs̎擾
const Matrix34& CollisionLeaf::getWorldMatrix() const{
	Assert(getParent() != NULL);
	return getParent()->getWorldMatrix();
}
//------------------------------------------------------------------------------
// [Js̎擾
const Matrix34& CollisionLeaf::getLocalMatrix() const{
	Assert(getParent() != NULL);
	return getParent()->getLocalMatrix();
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
