//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ÓIRW
 * @author Junpee
 */

#include "LampBasic.h"
#include "Collision/Leaf/StaticSphereCollision.h"
#include "Collision/System/CollisionScene.h"
#include "Geometry/System/IntersectionResult.h"

namespace Lamp{

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
StaticSphereCollision::StaticSphereCollision(
	const String& name, CollisionScene* scene) :
	StaticCollisionLeaf(name, scene),
	sphere_(Sphere::zero), worldSphere_(Sphere::zero){
}
//------------------------------------------------------------------------------
// fXgN^
StaticSphereCollision::~StaticSphereCollision(){
}
//------------------------------------------------------------------------------
// Rs[
//------------------------------------------------------------------------------
// ÓIRW̃Rs[
StaticSphereCollision*
	StaticSphereCollision::copyStaticSphereCollision() const{
	StaticSphereCollision* destination =
		getScene()->createStaticSphereCollision(
		getScene()->renameLeaf(getName()));
	// ÓIRW[t̒lRs[
	copyStaticCollisionLeafValue(destination);
	// õRs[
	destination->sphere_ = sphere_;
	destination->worldSphere_ = worldSphere_;
	return destination;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
void StaticSphereCollision::intersection(
	IntersectionResult* result, const Sphere& sphere, u_int collisionMask){
	// O[oł̗LA
	if(!isGlobalEnabled()){ return; }
	// RW}XN
	if((getCollisionMask() & collisionMask) == 0){ return; }
	// 
	Intersection intersection;
	if(worldSphere_.intersect(&intersection, sphere)){
		result->add(intersection);
	}
}
//------------------------------------------------------------------------------
// RW
void StaticSphereCollision::intersection(IntersectionResult* result,
	StaticSphereCollision* sphere, u_int collisionMask){
	// gȂȂ
	if(sphere == this){ return; }
	// O[oł̗LA
	if(!isGlobalEnabled()){ return; }
	// RW}XN
	if((getCollisionMask() & collisionMask) == 0){ return; }
	// 
	Intersection intersection;
	if(worldSphere_.intersect(&intersection, sphere->getWorldSphere())){
		result->add(intersection);
	}
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
void StaticSphereCollision::traverseImplement(
	const Matrix34& parentMatrix, bool parentEnabled, bool parentScaled,
	bool parentChanged){
	// ̃ZbgAbv
	if(!traverseSetup(parentEnabled, parentChanged)){ return; }

	// ̕ϊ
	if(parentScaled){
		// XP[
		worldSphere_ = sphere_.scaledTransform(parentMatrix);
	}else{
		// XP[
		worldSphere_ = sphere_.transform(parentMatrix);
	}

	// c[ւ̑}A܂̓c[̈ړ
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
