//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ÓIό`bVRW
 * @author Junpee
 */

#include "LampBasic.h"
#include "Collision/Leaf/StaticDeformedMeshCollision.h"
#include "Collision/System/CollisionScene.h"
#include "Collision/System/CollisionNode.h"
#include "Collision/Leaf/StaticSphereCollision.h"

namespace Lamp{

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
StaticDeformedMeshCollision::StaticDeformedMeshCollision(
	const String& name, CollisionScene* scene) :
	StaticCollisionLeaf(name, scene), worldMeshChanged_(true){
}
//------------------------------------------------------------------------------
// fXgN^
StaticDeformedMeshCollision::~StaticDeformedMeshCollision(){
}
//------------------------------------------------------------------------------
// Rs[
//------------------------------------------------------------------------------
// ÓIό`bVRW̃Rs[
StaticDeformedMeshCollision*
	StaticDeformedMeshCollision::copyStaticDeformedMeshCollision() const{
	StaticDeformedMeshCollision* destination =
		getScene()->createStaticDeformedMeshCollision(
		getScene()->renameLeaf(getName()));
	// ÓIRW[t̒lRs[
	copyStaticCollisionLeafValue(destination);
	// õRs[
	destination->mesh_ = mesh_;
	destination->worldMesh_ = worldMesh_;
	Assert(destination->worldMeshChanged_);
	return destination;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
void StaticDeformedMeshCollision::intersection(
	IntersectionResult* result, const Sphere& sphere, u_int collisionMask){
	// O[oł̗LA
	if(!isGlobalEnabled()){ return; }
	// RW}XN
	if((getCollisionMask() & collisionMask) == 0){ return; }
	// oEfBO
	if(!worldMesh_.intersectBounding(sphere)){ return; }
	// bVA[hbV̎Zos
	getWorldMesh().intersectMesh(result, sphere);
}
//------------------------------------------------------------------------------
// RW
void StaticDeformedMeshCollision::intersection(IntersectionResult* result,
	StaticSphereCollision* sphere, u_int collisionMask){
	// O[oł̗LA
	if(!isGlobalEnabled()){ return; }
	// RW}XN
	if((getCollisionMask() & collisionMask) == 0){ return; }
	// oEfBO
	const Sphere& worldSphere = sphere->getWorldSphere();
	if(!worldMesh_.intersectBounding(worldSphere)){ return; }
	// bV
	if(isScaled()){
		// XP[̏ꍇ̓[hbVZoČ
		getWorldMesh().intersectMesh(result, worldSphere);
	}else{
		// XP[̏ꍇ͋[JWɎĂČ
		Matrix34 matrix;
		getWorldMatrix().invertTransformation(&matrix);
		Sphere localSphere = worldSphere.transform(matrix);
		getMesh().intersectMesh(result, localSphere);
	}
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
void StaticDeformedMeshCollision::traverseImplement(
	const Matrix34& parentMatrix, bool parentEnabled, bool parentScaled,
	bool parentChanged){
	// ̃ZbgAbv
	if(!traverseSetup(parentEnabled, parentChanged)){ return; }

	// [hoEfBO̍\z
	if(parentScaled){
		// XP[oEfBO
		worldMesh_.setBoundingBox(
			mesh_.getBoundingBox().transform(parentMatrix));
		worldMesh_.setBoundingSphere(
			mesh_.getBoundingSphere().scaledTransform(parentMatrix));
	}else{
		// XP[oEfBO
		worldMesh_.setBoundingBox(
			mesh_.getBoundingBox().transform(parentMatrix));
		worldMesh_.setBoundingSphere(
			mesh_.getBoundingSphere().transform(parentMatrix));
	}

	// [hbVύXtO𗧂Ă
	worldMeshChanged_ = true;

	// c[ւ̑}A܂̓c[̈ړ
}
//------------------------------------------------------------------------------
// bV
//------------------------------------------------------------------------------
// [hbV̎擾
const DeformedMeshGeometry& StaticDeformedMeshCollision::getWorldMesh(){
	// LłȂƃ[hbV͐Ȃ
	Assert(isGlobalEnabled());

	// [hbVɕύXȂ΂̂܂ܕԂ
	if(!worldMeshChanged_){ return worldMesh_; }
	// [hbVύXtÕNA
	worldMeshChanged_ = false;

	// gXtH[
	Assert(getParent() != NULL);
	const Matrix34& matrix = getParent()->getWorldMatrix();
	int triangleCount = mesh_.getTriangleCount();
	for(int i = 0; i < triangleCount; i++){
		worldMesh_.setTriangle(i, mesh_.getTriangle(i).transform(matrix));
	}
	return worldMesh_;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
