//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * xNgzԎ
 * @author Junpee
 */

#include "LampBasic.h"
#include "Animation/VectorInterpolator/VectorArrayInterpolator.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
VectorArrayInterpolator::VectorArrayInterpolator() :
	array_(NULL), size_(0), length_(0.f){
}
//------------------------------------------------------------------------------
// fXgN^
VectorArrayInterpolator::~VectorArrayInterpolator(){
	SafeArrayDelete(array_);
}
//------------------------------------------------------------------------------
// Rs[RXgN^
VectorArrayInterpolator::VectorArrayInterpolator(
	const VectorArrayInterpolator& copy){
	size_ = copy.size_;
	length_ = copy.length_;
	// Rs[RXgN^͋INULLݒ
	array_ = NULL;
	if(size_ == 0){ return; }
	array_ = new Vector3[size_];
	std::memcpy(array_, copy.array_, sizeof(Vector3) * size_);
}
//------------------------------------------------------------------------------
// Zq
VectorArrayInterpolator& VectorArrayInterpolator::operator =(
	const VectorArrayInterpolator& copy){
	// gȂ烊^[
	if(this == &copy){ return *this; }
	size_ = copy.size_;
	length_ = copy.length_;
	// ̍ۂ͉NULLݒ
	SafeArrayDelete(array_);
	if(size_ == 0){ return *this; }
	array_ = new Vector3[size_];
	std::memcpy(array_, copy.array_, sizeof(Vector3) * size_);
	return *this;
}
//------------------------------------------------------------------------------
// oEfBO
//------------------------------------------------------------------------------
// oEfBO{bNX̎擾
AxisAlignedBox VectorArrayInterpolator::getBoundingBox() const{
	AxisAlignedBox result(AxisAlignedBox::zero);
	if(size_ == 0){ return result; }
	result.set(array_[0], array_[0]);
	for(int i = 1; i < size_; i++){ result.merge(array_[i]); }
	return result;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
Vector3 VectorArrayInterpolator::interpolate(float time){
	Assert(array_ != NULL);
	// ԂOɂӂĂ
	if(time <= 0.f){ return array_[0]; }
	// ԂɂӂĂ
	if(time >= length_){ return array_[size_ - 1]; }
	// `
	float integer, rate;
	rate = Math::modf(time, &integer);
	int index = (int)integer;
	Vector3 preValue = array_[index];
	preValue *= (1.f - rate);
	Vector3 postValue = array_[index + 1];
	postValue *= rate;
	preValue += postValue;
	return preValue;
}
//------------------------------------------------------------------------------
// l
//------------------------------------------------------------------------------
// TCYݒ
void VectorArrayInterpolator::setSize(int size){
	// Ԃׂ̈ɂ2ȏsizeKv
	Assert(size > 1);
	size_ = size;
	length_ = (float)(size_ - 1);
	SafeArrayDelete(array_);
	array_ = new Vector3[size_];
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
