//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Aj[VZbg
 * @author Junpee
 */

#include "LampBasic.h"
#include "Animation/System/AnimationSet.h"
#include "Animation/System/AnimationManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
AnimationSet::AnimationSet(String name, AnimationManager* manager) :
	Animation(name, manager){
}
//------------------------------------------------------------------------------
// fXgN^
AnimationSet::~AnimationSet(){
}
//------------------------------------------------------------------------------
// oCh
bool AnimationSet::bind(Scene* scene){
	// SẴoChΐ
	bool result = true;
	int animationCount = getAnimationCount();
	for(int i = 0; i < animationCount; i++){
		if(!getAnimation(i)->bind(scene)){ result = false; }
	}
	return result;
}
//------------------------------------------------------------------------------
// oCh
void AnimationSet::unbind(){
	int animationCount = getAnimationCount();
	for(int i = 0; i < animationCount; i++){
		getAnimation(i)->unbind();
	}
}
//------------------------------------------------------------------------------
// V[PX̎擾
int AnimationSet::getSequenceCount() const{
	// ԏV[PXo
	int animationCount = getAnimationCount();
	if(animationCount == 0){ return 0; }
	int result = getAnimation(0)->getSequenceCount();
	for(int i = 1; i < animationCount; i++){
		int count = getAnimation(i)->getSequenceCount();
		if(count < result){ result = count; }
	}
	return result;
}
//------------------------------------------------------------------------------
// V[PX̐ݒ
void AnimationSet::setSequence(int sequence, float time){
	Assert(sequence >= 0);
	Assert(sequence < getSequenceCount());
	int animationCount = getAnimationCount();
	for(int i = 0; i < animationCount; i++){
		getAnimation(i)->setSequence(sequence, time);
	}
}
//------------------------------------------------------------------------------
// V[PX̎擾
int AnimationSet::getSequence() const{
	// ԏV[PXo
	int animationCount = getAnimationCount();
	if(animationCount == 0){ return 0; }
	int result = getAnimation(0)->getSequence();
	for(int i = 1; i < animationCount; i++){
		int sequence = getAnimation(i)->getSequence();
		if(sequence < result){ result = sequence; }
	}
	return result;
}
//------------------------------------------------------------------------------
// Ԃ̐ݒ
void AnimationSet::setTime(float time){
	int animationCount = getAnimationCount();
	for(int i = 0; i < animationCount; i++){ getAnimation(i)->setTime(time); }
}
//------------------------------------------------------------------------------
// Ԃ̎擾
float AnimationSet::getTime() const{
	// ԏԂo
	int animationCount = getAnimationCount();
	if(animationCount == 0){ return 0.f; }
	float result = getAnimation(0)->getTime();
	for(int i = 1; i < animationCount; i++){
		float time = getAnimation(i)->getTime();
		if(time < result){ result = time; }
	}
	return result;
}
//------------------------------------------------------------------------------
// Aj[V
bool AnimationSet::animate(float deltaTime, AnimationMask mask){
	// LłȂ΃Aj[VȂ
	if(!isEnabled()){ return true; } 
	// SẴAj[VIĂtrue
	bool result = true;
	int animationCount = getAnimationCount();
	for(int i = 0; i < animationCount; i++){
		if(!getAnimation(i)->animate(deltaTime, mask)){ result = false; }
	}
	return result;
}
//------------------------------------------------------------------------------
// ̎擾
float AnimationSet::getLength() const{
	// Ԓ擾
	int animationCount = getAnimationCount();
	if(animationCount == 0){ return 0.f; }
	float result = getAnimation(0)->getLength();
	for(int i = 1; i < animationCount; i++){
		float length = getAnimation(i)->getLength();
		if(length > result){ result = length; }
	}
	return result;
}
//------------------------------------------------------------------------------
// IĂ邩
bool AnimationSet::isFinished() const{
	// SĂIĂtrue
	bool result = true;
	int animationCount = getAnimationCount();
	for(int i = 0; i < animationCount; i++){
		if(!getAnimation(i)->isFinished()){ result = false; }
	}
	return result;
}
//------------------------------------------------------------------------------
// [vĂ邩
bool AnimationSet::isLooped() const{
	// ł[vĂtrue;
	int animationCount = getAnimationCount();
	for(int i = 0; i < animationCount; i++){
		if(getAnimation(i)->isLooped()){ return true; }
	}
	return false;
}
//------------------------------------------------------------------------------
// Aj[VZbg̃Rs[
AnimationSet* AnimationSet::copyAnimationSet(DataCopyMask dataCopyMask) const{
	AnimationSet* animation = getManager()->createAnimationSet(getName());
	animation->setEnabled(isEnabled());
	int animationCount = getAnimationCount();
	for(int i = 0; i < animationCount; i++){
		animation->addAnimation(getAnimation(i)->copy(dataCopyMask));
	}
	return animation;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
