//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[m[hAj[V
 * @author Junpee
 */

#include "LampBasic.h"
#include "Animation/SceneNode/SceneNodeAnimation.h"
#include "Animation/System/AnimationManager.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/SceneNode/SceneNodeManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
SceneNodeAnimation::SceneNodeAnimation(String name, AnimationManager* manager) :
	ObjectAnimation(name, manager), animationData_(NULL), target_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
SceneNodeAnimation::~SceneNodeAnimation(){
}
//------------------------------------------------------------------------------
// oCh
bool SceneNodeAnimation::bind(Scene* scene){
	// ^[Qbgw肳ĂȂΎs
	if(getTargetName().getSize() == 0){ return false; }
	// V[m[ȟ
	SceneNode* sceneNode =
		scene->getSceneNodeManager()->search(getTargetName());
	if(sceneNode == NULL){ return false; }
	target_ = sceneNode;
	return true;
}
//------------------------------------------------------------------------------
// oCh
bool SceneNodeAnimation::bind(SceneNode* sceneNode){
	if(sceneNode == NULL){ return false; }
	setTargetName(sceneNode->getName());
	target_ = sceneNode;
	return true;
}
//------------------------------------------------------------------------------
// Aj[V
bool SceneNodeAnimation::animate(float deltaTime, AnimationMask mask){
	// `FbN
	if((mask & maskSceneNode) == 0){ return true; }
	if(!isEnabled()){ return true; } 
	if(animationData_ == NULL){ return true; }
	if(target_ == NULL){ return true; }
	// ΏۂLłȂ΃Aj[VȂ
	if(!target_->isEnabled()){ return true; }

	// Aj[V
	int sequence = getSequence();
	float correctTime = increasesTime(deltaTime);
	SceneNodeAnimationData* data = getSceneNodeAnimationData();
	// XP[
	VectorInterpolator* scale = data->getScale(sequence);
	if(scale != NULL){
		target_->setScale(scale->interpolate(correctTime));
	}
	// ]
	RotationInterpolator* rotation = data->getRotation(sequence);
	if(rotation != NULL){
		if(rotation->isQuaternionInterpolator()){
			target_->setRotationQuaternion(
				rotation->quaternionInterpolate(correctTime));
		}else if(rotation->isEulerInterpolator()){
			target_->setRotationXYZ(rotation->eulerInterpolate(correctTime));
		}else{
			ErrorOut("SceneNodeAnimation::animate() "
				"Unsupported Rotation type");
		}
	}
	// ړ
	VectorInterpolator* translation = data->getTranslation(sequence);
	if(translation != NULL){
		target_->setTranslation(translation->interpolate(correctTime));
	}
	return isFinished();
}
//------------------------------------------------------------------------------
// V[m[hAj[ṼRs[
SceneNodeAnimation* SceneNodeAnimation::copySceneNodeAnimation(
	DataCopyMask dataCopyMask) const{
	SceneNodeAnimation* animation = getManager()->createSceneNode(getName());
	copyObjectAnimationValue(animation);
	// Aj[Vf[^̃Rs[
	if((dataCopyMask & copySceneNode) == copySceneNode){
		animation->animationData_ =
			animationData_->copySceneNodeAnimationData();
	}else{
		animation->animationData_ = animationData_;
	}
	animation->animationData_->addReference();
	animation->bind(target_);
	return animation;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
