//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * l]zԎ
 * @author Junpee
 */

#include "LampBasic.h"
#include "Animation/RotationInterpolator/QuaternionArrayInterpolator.h"
#include "Animation/RotationInterpolator/EulerArrayInterpolator.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
QuaternionArrayInterpolator::QuaternionArrayInterpolator() :
	array_(NULL), size_(0), length_(0.f){
}
//------------------------------------------------------------------------------
// fXgN^
QuaternionArrayInterpolator::~QuaternionArrayInterpolator(){
	SafeArrayDelete(array_);
}
//------------------------------------------------------------------------------
// Rs[RXgN^
QuaternionArrayInterpolator::QuaternionArrayInterpolator(
	const QuaternionArrayInterpolator& copy){
	size_ = copy.size_;
	length_ = copy.length_;
	// Rs[RXgN^͋INULLݒ
	array_ = NULL;
	if(size_ == 0){ return; }
	array_ = new Quaternion[size_];
	std::memcpy(array_, copy.array_, sizeof(Quaternion) * size_);
}
//------------------------------------------------------------------------------
// Zq
QuaternionArrayInterpolator&
	QuaternionArrayInterpolator::operator =(
	const QuaternionArrayInterpolator& copy){
	// gȂ烊^[
	if(this == &copy){ return *this; }
	size_ = copy.size_;
	length_ = copy.length_;
	// ̍ۂ͉NULLݒ
	SafeArrayDelete(array_);
	if(size_ == 0){ return *this; }
	array_ = new Quaternion[size_];
	std::memcpy(array_, copy.array_, sizeof(Quaternion) * size_);
	return *this;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// IC[
Vector3 QuaternionArrayInterpolator::eulerInterpolate(float time){
	// NH[^jIŕԂăIC[pɕϊ
	Quaternion resultQuaternion = quaternionInterpolate(time);
	Vector3 result;
	resultQuaternion.getRotationXYZ(&result);
#ifdef _DEBUG
	if((!Math::classCheck(result.x)) ||
		(!Math::classCheck(result.y)) ||
		(!Math::classCheck(result.z))){
		_asm{ int 3 }
	}
#endif
	return result;
}
//------------------------------------------------------------------------------
// l
Quaternion QuaternionArrayInterpolator::quaternionInterpolate(float time){
	Assert(array_ != NULL);
	// ԂOɂӂĂ
	if(time <= 0.f){ return array_[0]; }
	// ԂɂӂĂ
	if(time >= length_){ return array_[size_ - 1]; }
	// 
	float integer, rate;
	rate = Math::modf(time, &integer);
	int index = (int)integer;
	// NH[^jI
	const Quaternion& pre = array_[index];
	const Quaternion& post = array_[index + 1];
	// l̕␳ĂΈȂ
	Assert(pre.dotProduct(post) >= 0.f);
	Assert(pre.isUnit() && post.isUnit());
	Quaternion result = Quaternion::slerp(pre, post, rate);
#ifdef _DEBUG
	if((!Math::classCheck(result.x)) ||
		(!Math::classCheck(result.y)) ||
		(!Math::classCheck(result.z)) ||
		(!Math::classCheck(result.w))){
		_asm{ int 3 }
	}
#endif
	return result;
}
//------------------------------------------------------------------------------
// l
//------------------------------------------------------------------------------
// TCYݒ
void QuaternionArrayInterpolator::setSize(int size){
	// Ԃׂ̈ɂ2ȏsizeKv
	Assert(size > 1);
	size_ = size;
	length_ = (float)(size_ - 1);
	SafeArrayDelete(array_);
	array_ = new Quaternion[size_];
}
//------------------------------------------------------------------------------
// l̐ݒ
void QuaternionArrayInterpolator::setValue(
	int index, const Quaternion& value){
	Assert(array_ != NULL);
	Assert(index >= 0);
	Assert(index < size_);
	// PʎlɂĂ
	Quaternion correctValue(value);
	correctValue.normalize();
	array_[index] = correctValue;
}
//------------------------------------------------------------------------------
// l̕␳
void QuaternionArrayInterpolator::correctValue(){
	Assert(array_ != NULL);
	for(int i = 0; i < size_; i++){ array_[i].normalize(); }
	for(int i = 1; i < size_; i++){
		if(array_[i - 1].dotProduct(array_[i]) < 0.f){ array_[i] = -array_[i]; }
	}
}
//------------------------------------------------------------------------------
// ϊ
//------------------------------------------------------------------------------
// IC[]zԂւ̕ϊ
EulerArrayInterpolator*
	QuaternionArrayInterpolator::convertEulerArrayInterpolator() const{
	EulerArrayInterpolator* result = new EulerArrayInterpolator();
	int size = getSize();
	result->setSize(size);
	Vector3 euler;
	for(int i = 0; i < size; i++){
		getValue(i).getRotationXYZ(&euler);
		result->setValue(i, euler);
	}
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
