//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * JAj[V
 * @author Junpee
 */

#include "LampBasic.h"
#include "Animation/Camera/CameraAnimation.h"
#include "Animation/System/AnimationManager.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Camera/CameraManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
CameraAnimation::CameraAnimation(String name, AnimationManager* manager) :
	ObjectAnimation(name, manager), animationData_(NULL), target_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
CameraAnimation::~CameraAnimation(){
}
//------------------------------------------------------------------------------
// oCh
bool CameraAnimation::bind(Scene* scene){
	// ^[Qbgw肳ĂȂΎs
	if(getTargetName().getSize() == 0){ return false; }
	// J̌
	Camera* camera =
		scene->getCameraManager()->search(getTargetName());
	if(camera == NULL){ return false; }
	target_ = camera;
	return true;
}
//------------------------------------------------------------------------------
// oCh
bool CameraAnimation::bind(Camera* camera){
	if(camera == NULL){ return false; }
	setTargetName(camera->getName());
	target_ = camera;
	return true;
}
//------------------------------------------------------------------------------
// Aj[V
bool CameraAnimation::animate(float deltaTime, AnimationMask mask){
	// `FbN
	if((mask & maskCamera) == 0){ return true; }
	if(!isEnabled()){ return true; } 
	if(animationData_ == NULL){ return true; }
	if(target_ == NULL){ return true; }

	// Aj[V
	int sequence = getSequence();
	float correctTime = increasesTime(deltaTime);
	CameraAnimationData* data = getCameraAnimationData();
	// ]Aړ
	RotationInterpolator* rotationInterpolator = data->getRotation(sequence);
	VectorInterpolator* translationInterpolator =
		data->getTranslation(sequence);
	if((rotationInterpolator == NULL) && (translationInterpolator == NULL)){
		return true;
	}
	Vector3 translation(0.f, 0.f, 0.f);
	if(translationInterpolator != NULL){
		translation = translationInterpolator->interpolate(correctTime);
	}
	if(rotationInterpolator == NULL){
		target_->setTransformation(Vector3::zero, translation);
	}else{
		if(rotationInterpolator->isQuaternionInterpolator()){
			target_->setTransformation(
				rotationInterpolator->quaternionInterpolate(correctTime),
				translation);
		}else if(rotationInterpolator->isEulerInterpolator()){
			target_->setTransformation(
				rotationInterpolator->eulerInterpolate(correctTime),
				translation);
		}else{
			ErrorOut("CameraAnimation::animate() "
				"Unsupported Rotation type");
		}
	}
	return isFinished();
}
//------------------------------------------------------------------------------
// JAj[ṼRs[
CameraAnimation* CameraAnimation::copyCameraAnimation(
	DataCopyMask dataCopyMask) const{
	CameraAnimation* animation = getManager()->createCamera(getName());
	copyObjectAnimationValue(animation);
	// Aj[Vf[^̃Rs[
	if((dataCopyMask & copyCamera) == copyCamera){
		animation->animationData_ =
			animationData_->copyCameraAnimationData();
	}else{
		animation->animationData_ = animationData_;
	}
	animation->animationData_->addReference();
	animation->bind(target_);
	return animation;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
